/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mega;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DekaTrampleAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "deka_trample", new Pair[]{ImmutablePair.of((Object)"Running speed increases with acceleration trampling any nearby entity.", null)});
    private static final float TRAMPLE_AREA = 5.0f;
    private static final int BLOCK_BREAKING_AREA = 7;
    private static final float MAX_SPEED = 0.45f;
    private static final float DAMAGE = 8.0f;
    public static final AbilityCore<DekaTrampleAbility> INSTANCE = new AbilityCore.Builder<DekaTrampleAbility>("Deka Trample", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, DekaTrampleAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, RangeComponent.getTooltip(5.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(8.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.MEGA.get(), new MorphInfo[0]);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(100);
    public float speed = 0.0f;

    public DekaTrampleAbility(AbilityCore<DekaTrampleAbility> ability) {
        super(ability);
        this.addComponents(this.rangeComponent, this.dealDamageComponent, this.requireMorphComponent);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    public void duringPassiveEvent(LivingEntity entity) {
        if (!entity.func_233570_aj_()) {
            return;
        }
        if (MorphHelper.getZoanInfo(entity) != ModMorphs.MEGA.get()) {
            return;
        }
        if (!entity.func_70051_ag()) {
            this.speed = 0.0f;
        } else {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, entity.func_233580_cy_(), 5.0f);
            float acceleration = 0.004f;
            acceleration *= this.speed > 0.0f ? 1.0f - this.speed / 0.45f : 1.0f;
            if (!(entity.field_191988_bg > 0.0f) || entity.field_70123_F) {
                acceleration = -0.044999998f;
            }
            this.speed = MathHelper.func_76131_a((float)(this.speed + acceleration), (float)0.2f, (float)0.45f);
            boolean d2 = entity.field_191988_bg > 0.0f;
            Vector3d vec = entity.func_70040_Z();
            double x = vec.field_72450_a * (double)this.speed * (double)d2;
            double z = vec.field_72449_c * (double)this.speed * (double)d2;
            AbilityHelper.setDeltaMovement((Entity)entity, x, entity.func_213322_ci().field_72448_b, z);
            if (!entity.field_70170_p.field_72995_K) {
                List<BlockPos> blocks = WyHelper.getNearbyBlocks(entity.func_233580_cy_(), (IWorld)entity.field_70170_p, 7, 7, 7, state -> !state.func_185904_a().equals(Material.field_151579_a) && FoliageBlockProtectionRule.INSTANCE.isApproved((BlockState)state));
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                for (BlockPos pos : blocks) {
                    if (!AbilityHelper.placeBlockIfAllowed(entity, pos, Blocks.field_150350_a.func_176223_P(), FoliageBlockProtectionRule.INSTANCE)) continue;
                    positions.add(pos);
                }
                if (positions.size() > 0) {
                    this.details.setPositions(positions);
                    WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
                }
                for (LivingEntity target : targets) {
                    if (!this.dealDamageComponent.hurtTarget(entity, target, 8.0f)) continue;
                    Vector3d speed = WyHelper.propulsion(entity, 2.0, 2.0);
                    AbilityHelper.setDeltaMovement((Entity)target, speed.field_72450_a, 0.2, speed.field_72449_c);
                }
            }
        }
    }
}

