/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.DaiEnkaiEnteiProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.DaiEnkaiOnibiProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.mera.HibashiraParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class DaiEnkaiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "dai_enkai_entei", new Pair[]{ImmutablePair.of((Object)"Amasses the user's flames into a gigantic fireball that the user hurls at the opponent", null), ImmutablePair.of((Object)"Creates a giant fire vortex around the user, trapping enemies within it and creating three fire dragons that will be shot towards the enemy at the end.", null)});
    private static final TranslationTextComponent DAI_ENKAI_ENTEI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.dai_enkai_entei", "Dai Enkai: Entei"));
    private static final TranslationTextComponent DAI_ENKAI_ONIBI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.dai_enkai_onibi", "Dai Enkai: Onibi"));
    private static final ResourceLocation DAI_ENKAI_ENTEI_ICON = new ResourceLocation("mineminenomi", "textures/abilities/dai_enkai_entei.png");
    private static final ResourceLocation DAI_ENKAI_ONIBI_ICON = new ResourceLocation("mineminenomi", "textures/abilities/dai_enkai_onibi.png");
    private static final float COOLDOWN = 500.0f;
    private static final float ENTEI_CHARGE_TIME = 160.0f;
    private static final float ENTEI_ON_HOLD_TIME = 160.0f;
    private static final float ONIBI_CHARGE_TIME = 100.0f;
    private static final double PILLAR_SIZE = 25.0;
    private static final float ENTEI_MIN_DAMAGE = 24.0f;
    private static final float ENTEI_MAX_DAMAGE = 104.0f;
    private static final float ONIBI_PROJ_DAMAGE = 75.0f;
    private static final float ONIBI_PILLAR_DAMAGE = 5.0f;
    private Vector3d onibiStartPos = Vector3d.field_186680_a;
    private static final AbilityDescriptionLine.IDescriptionLine<DaiEnkaiAbility> ONIBI_DAMAGE_TOOLTIP = (entity, ability) -> {
        AbilityProjectileEntity proj = ability.getComponent(ModAbilityKeys.PROJECTILE).map(comp -> comp.getCachedProjectile(entity)).orElse(null);
        if (proj != null && proj.getDamage() > 0.0f) {
            float bonus = ability.getComponent(ModAbilityKeys.PROJECTILE).map(ProjectileComponent::getDamageBonusManager).map(manager -> Float.valueOf(manager.applyBonus(proj.getDamage()) - proj.getDamage())).orElse(Float.valueOf(0.0f)).floatValue();
            AbilityStat.AbilityStatType bonusType = bonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (bonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_DAMAGE, 75.0f).withBonus(bonus, bonusType).withUnit((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_X3);
            return statBuilder.build().getStatDescription(2);
        }
        return null;
    };
    private static final AbilityDescriptionLine.IDescriptionLine<DaiEnkaiAbility> ENTEI_DAMAGE_TOOLTIP = (entity, ability) -> {
        AbilityProjectileEntity proj = ability.getComponent(ModAbilityKeys.PROJECTILE).map(comp -> comp.getCachedProjectile(entity)).orElse(null);
        if (proj != null && proj.getDamage() > 0.0f) {
            float bonus = ability.getComponent(ModAbilityKeys.PROJECTILE).map(ProjectileComponent::getDamageBonusManager).map(manager -> Float.valueOf(manager.applyBonus(proj.getDamage()) - proj.getDamage())).orElse(Float.valueOf(0.0f)).floatValue();
            AbilityStat.AbilityStatType bonusType = bonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (bonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_DAMAGE, 24.0f, 104.0f).withBonus(bonus, bonusType);
            return statBuilder.build().getStatDescription(2);
        }
        return null;
    };
    public static final AbilityCore<DaiEnkaiAbility> INSTANCE = new AbilityCore.Builder<DaiEnkaiAbility>("Dai Enkai: Entei", AbilityCategory.DEVIL_FRUITS, DaiEnkaiAbility::new).addAdvancedDescriptionLine((e, a) -> DAI_ENKAI_ENTEI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip(500.0f), ChargeComponent.getTooltip(160.0f), ContinuousComponent.getTooltip(160.0f), (e, a) -> new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_PROJECTILE.getString() + "\u00a7r"), ENTEI_DAMAGE_TOOLTIP).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> DAI_ENKAI_ONIBI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip(500.0f), ChargeComponent.getTooltip(100.0f), (e, a) -> new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_PROJECTILE.getString() + "\u00a7r"), ONIBI_DAMAGE_TOOLTIP).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent(this).addSwingEvent(this::onSwing);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.ENTEI).addChangeModeEvent(this::onAltModeChange);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final Interval particleInterval = new Interval(2);
    private final Interval clearHitsInterval = new Interval(20);
    private DaiEnkaiEnteiProjectile enteiProjectile;
    private DaiEnkaiOnibiProjectile[] onibiProjectiles = new DaiEnkaiOnibiProjectile[3];

    public DaiEnkaiAbility(AbilityCore<DaiEnkaiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.chargeComponent, this.swingTriggerComponent, this.altModeComponent, this.animationComponent, this.projectileComponent, this.hitTrackerComponent, this.dealDamageComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.ENTEI) {
            if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
                this.chargeComponent.startCharging(entity, 160.0f);
            } else if (this.enteiProjectile != null && this.enteiProjectile.func_70089_S()) {
                this.enteiProjectile.onBlockImpactEvent(this.enteiProjectile.func_233580_cy_());
                this.enteiProjectile.func_70106_y();
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ONIBI) {
            if (!entity.func_233570_aj_()) {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{super.getDisplayName()}), Util.field_240973_b_);
                return;
            }
            this.chargeComponent.startCharging(entity, 100.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.particleInterval.restartIntervalToZero();
        if (this.altModeComponent.getCurrentMode() == Mode.ENTEI) {
            this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
            this.enteiProjectile = (DaiEnkaiEnteiProjectile)this.projectileComponent.getNewProjectile(entity);
            this.enteiProjectile.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 7.5, entity.func_226281_cx_());
            entity.field_70170_p.func_217376_c((Entity)this.enteiProjectile);
        } else if (this.altModeComponent.getCurrentMode() == Mode.ONIBI) {
            this.onibiStartPos = entity.func_213303_ch();
            this.animationComponent.start(entity, ModAnimations.RAISE_ARMS);
            float f1 = -entity.field_70177_z * ((float)Math.PI / 180);
            float f2 = MathHelper.func_76134_b((float)f1);
            float f3 = MathHelper.func_76126_a((float)f1);
            Vector3d throwerLook = new Vector3d((double)f3, 0.0, (double)f2);
            double offsetX = throwerLook.field_72450_a * 30.0;
            double offsetY = 20.0;
            double offsetZ = throwerLook.field_72449_c * 30.0;
            this.onibiProjectiles = new DaiEnkaiOnibiProjectile[]{(DaiEnkaiOnibiProjectile)((Object)this.projectileComponent.getNewProjectile(entity)), (DaiEnkaiOnibiProjectile)((Object)this.projectileComponent.getNewProjectile(entity)), (DaiEnkaiOnibiProjectile)((Object)this.projectileComponent.getNewProjectile(entity))};
            this.onibiProjectiles[0].func_70107_b(entity.func_226277_ct_() + offsetZ, entity.func_226278_cu_() + offsetY, entity.func_226281_cx_() - offsetX);
            this.onibiProjectiles[1].func_70107_b(entity.func_226277_ct_() - offsetX, entity.func_226278_cu_() + offsetY, entity.func_226281_cx_() - offsetZ);
            this.onibiProjectiles[2].func_70107_b(entity.func_226277_ct_() - offsetZ, entity.func_226278_cu_() + offsetY, entity.func_226281_cx_() + offsetX);
            for (DaiEnkaiOnibiProjectile onibiProjectile : this.onibiProjectiles) {
                entity.field_70170_p.func_217376_c((Entity)onibiProjectile);
            }
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.ENTEI) {
            if (this.enteiProjectile == null || !this.enteiProjectile.func_70089_S()) {
                this.chargeComponent.stopCharging(entity);
                return;
            }
            this.enteiProjectile.setLife(this.enteiProjectile.getMaxLife());
            this.enteiProjectile.increaseSize();
            this.enteiProjectile.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 7.5, entity.func_226281_cx_());
            if (!entity.field_70170_p.field_72995_K && this.particleInterval.canTick()) {
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DAI_ENKAI_2.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ONIBI) {
            double yourDistance = 37.5;
            Vector3d lookAngle = entity.func_70040_Z();
            Vector3d targetPoint = entity.func_174824_e(1.0f).func_72441_c(lookAngle.field_72450_a * yourDistance, lookAngle.field_72448_b * yourDistance, lookAngle.field_72449_c * yourDistance);
            for (DaiEnkaiOnibiProjectile onibiProjectile : this.onibiProjectiles) {
                if (onibiProjectile == null || !onibiProjectile.func_70089_S()) continue;
                onibiProjectile.setLife(onibiProjectile.getMaxLife());
                Vector3d projectilePos = onibiProjectile.func_213303_ch();
                double totalDeltaX = targetPoint.field_72450_a - projectilePos.field_72450_a;
                double totalDeltaY = targetPoint.field_72448_b - projectilePos.field_72448_b;
                double totalDeltaZ = targetPoint.field_72449_c - projectilePos.field_72449_c;
                double distanceXZ = Math.sqrt(totalDeltaX * totalDeltaX + totalDeltaZ * totalDeltaZ);
                double pitch = -Math.atan2(totalDeltaY, distanceXZ);
                double yaw = Math.atan2(-totalDeltaX, totalDeltaZ);
                pitch = Math.toDegrees(pitch);
                yaw = Math.toDegrees(yaw);
                onibiProjectile.field_70177_z = (float)(-yaw);
                onibiProjectile.field_70125_A = (float)(-pitch);
            }
            if (!entity.field_70170_p.field_72995_K && this.particleInterval.canTick()) {
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HIBASHIRA.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new HibashiraParticleEffect.Details(10.0f, 4.0f, 4.0f));
            }
            double perimeter = 41.5;
            List<LivingEntity> targets = WyHelper.getEntitiesAroundCircle(entity.func_213303_ch(), (IWorld)entity.field_70170_p, perimeter, 4.0, ModEntityPredicates.getEnemyFactions(entity), LivingEntity.class);
            for (LivingEntity target : targets) {
                if (this.hitTrackerComponent.canHit((Entity)target) && this.dealDamageComponent.hurtTarget(entity, target, 5.0f)) {
                    target.func_70015_d(4);
                }
                Vector3d rejectionVec = this.onibiStartPos.func_178788_d(target.func_213303_ch()).func_72432_b();
                AbilityHelper.setDeltaMovement((Entity)target, rejectionVec);
            }
            if (this.clearHitsInterval.canTick()) {
                this.hitTrackerComponent.clearHits();
            }
            AbilityHelper.slowEntityFall(entity);
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.ENTEI) {
            this.continuousComponent.startContinuity(entity, 160.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.ONIBI) {
            for (DaiEnkaiOnibiProjectile onibiProjectile : this.onibiProjectiles) {
                if (onibiProjectile == null || !onibiProjectile.func_70089_S()) continue;
                onibiProjectile.func_234612_a_((Entity)entity, -onibiProjectile.field_70125_A, -onibiProjectile.field_70177_z, 0.0f, 3.0f, 1.0f);
            }
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 500.0f);
        }
    }

    private void onSwing(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.enteiProjectile.func_234612_a_((Entity)entity, entity.field_70125_A + 10.0f, entity.field_70177_z, 0.0f, 3.0f, 1.0f);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MERA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            if (!entity.field_70170_p.field_72995_K) {
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DAI_ENKAI_1.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            }
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.enteiProjectile == null || !this.enteiProjectile.func_70089_S()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.enteiProjectile.setLife(this.enteiProjectile.getMaxLife());
        this.enteiProjectile.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 7.5, entity.func_226281_cx_());
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.enteiProjectile != null && this.enteiProjectile.func_70089_S() && this.enteiProjectile.getLife() < this.enteiProjectile.getMaxLife()) {
            this.enteiProjectile.onBlockImpactEvent(this.enteiProjectile.func_233580_cy_());
            this.enteiProjectile.func_70106_y();
        }
        this.enteiProjectile = null;
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.ENTEI) {
            super.setDisplayName((ITextComponent)DAI_ENKAI_ENTEI_NAME);
            super.setDisplayIcon(DAI_ENKAI_ENTEI_ICON);
        } else if (mode == Mode.ONIBI) {
            super.setDisplayName((ITextComponent)DAI_ENKAI_ONIBI_NAME);
            super.setDisplayIcon(DAI_ENKAI_ONIBI_ICON);
        }
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        if (this.altModeComponent.getCurrentMode() == Mode.ONIBI) {
            DaiEnkaiOnibiProjectile proj = new DaiEnkaiOnibiProjectile(entity.field_70170_p, entity, this);
            return proj;
        }
        DaiEnkaiEnteiProjectile proj = new DaiEnkaiEnteiProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    public static enum Mode {
        ENTEI,
        ONIBI;

    }
}

