/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.morgan;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.ShockwaveProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class MorganShockwaveAbility
extends Ability {
    private static final int COOLDOWN = 100;
    private static final int CHARGE_TIME = 40;
    public static final AbilityCore<MorganShockwaveAbility> INSTANCE = new AbilityCore.Builder<MorganShockwaveAbility>("Morgan's Shockwave", AbilityCategory.STYLE, MorganShockwaveAbility::new).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(100, this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private float speed = 2.0f;
    private float inaccuracy = 1.0f;
    private float damage = 10.0f;
    private int shockwaveSize = 2;
    private boolean canBreakBlocks = false;

    public MorganShockwaveAbility(AbilityCore<MorganShockwaveAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.animationComponent);
        super.addUseEvent(this::onUseEvent);
    }

    public void setHardForm() {
        this.speed = 4.0f;
        this.inaccuracy = 0.0f;
        this.damage = 20.0f;
        this.shockwaveSize = 4;
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.LOWERING_RIGHT_ARM);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        ShockwaveProjectile proj = new ShockwaveProjectile(entity.field_70170_p, entity, INSTANCE, true);
        proj.setSize(this.shockwaveSize);
        proj.setDamage(this.damage);
        proj.setBreakBlocks(this.canBreakBlocks);
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, this.speed, this.inaccuracy);
        entity.field_70170_p.func_217376_c((Entity)proj);
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }
}

