/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nekoleopard;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FerociousLeapAbility
extends DropHitAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ferocious_leap", new Pair[]{ImmutablePair.of((Object)"Leaps at the enemy and damages all nearby entities on landing.", null)});
    private static final float COOLDOWN = 160.0f;
    private static final float DAMAGE = 10.0f;
    private static final float RANGE = 3.5f;
    public static final AbilityCore<FerociousLeapAbility> INSTANCE = new AbilityCore.Builder<FerociousLeapAbility>("Ferocious Leap", AbilityCategory.DEVIL_FRUITS, FerociousLeapAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), DealDamageComponent.getTooltip(10.0f), RangeComponent.getTooltip(3.5f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.LEOPARD_HEAVY.get(), (MorphInfo)ModMorphs.LEOPARD_WALK.get());

    public FerociousLeapAbility(AbilityCore<FerociousLeapAbility> core) {
        super(core);
        this.addComponents(this.dealDamageComponent, this.rangeComponent, this.requireMorphComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    @Override
    public void onLanding(LivingEntity entity) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 3.5f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 10.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion(entity, 1.0, 1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 1.4, speed.field_72449_c);
    }
}

