/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nikyu;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PuniAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "puni", new Pair[]{ImmutablePair.of((Object)"The user takes a defensive posture that uses their paw pads to repel and counter enemy attacks", null)});
    private static final int COOLDOWN = 80;
    private static final int HOLD_TIME = 40;
    private static final float RANGE = 2.5f;
    private static final int DAMAGE = 15;
    public static final AbilityCore<PuniAbility> INSTANCE = new AbilityCore.Builder<PuniAbility>("Puni", AbilityCategory.DEVIL_FRUITS, PuniAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f), ContinuousComponent.getTooltip(40.0f), RangeComponent.getTooltip(2.5f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(15.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);

    public PuniAbility(AbilityCore<PuniAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.animationComponent, this.hitTrackerComponent, this.dealDamageComponent, this.damageTakenComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 40.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        Entity attacker;
        if (this.continuousComponent.isContinuous() && (attacker = damageSource.func_76364_f()) != null && attacker instanceof LivingEntity) {
            boolean lastAttackerDistance;
            LivingEntity target = (LivingEntity)attacker;
            boolean canSeeAttacker = TargetHelper.isEntityInView(entity, (Entity)target, 60.0f);
            boolean bl = lastAttackerDistance = target.func_70032_d((Entity)entity) < 6.25f;
            if (canSeeAttacker && lastAttackerDistance && this.hitTrackerComponent.canHit((Entity)target) && this.dealDamageComponent.hurtTarget(entity, target, 15.0f)) {
                Vector3d speed = WyHelper.propulsion(entity, 6.0, 6.0);
                AbilityHelper.setDeltaMovement((Entity)target, speed.field_72450_a, 1.5, speed.field_72449_c);
                return 0.0f;
            }
        }
        return damage;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        List<Entity> targets = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 2.5, null, new Class[0]);
        for (Entity target : targets) {
            if (target == entity || !TargetHelper.isEntityInView(entity, target, 60.0f) || !(target instanceof ProjectileEntity)) continue;
            AbilityHelper.setDeltaMovement(target, -target.func_213322_ci().field_72450_a, -target.func_213322_ci().field_72448_b, -target.func_213322_ci().field_72449_c);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 80.0f);
    }
}

