/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.noro;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ItemAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class NoroNoroBeamSwordAbility
extends ItemAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "noro_noro_beam_sword", new Pair[]{ImmutablePair.of((Object)"Focuses photons inside a hilt to create a sword, which slows enemies upon hit", null)});
    private static final float COOLDOWN = 20.0f;
    public static final AbilityCore<NoroNoroBeamSwordAbility> INSTANCE = new AbilityCore.Builder<NoroNoroBeamSwordAbility>("Noro Noro Beam Sword", AbilityCategory.DEVIL_FRUITS, NoroNoroBeamSwordAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f), ContinuousComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.FIST).build();
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::hitEvent).addTryHitEvent(this::tryHitEvent);

    public NoroNoroBeamSwordAbility(AbilityCore<NoroNoroBeamSwordAbility> core) {
        super(core);
        this.addComponents(this.hitTriggerComponent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 20.0f);
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    public boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.NORO_SLOWNESS.get(), 40, 1));
        return true;
    }

    @Override
    public ItemStack createItemStack(LivingEntity entity) {
        return new ItemStack((IItemProvider)ModWeapons.NORO_NORO_BEAM_SWORD.get());
    }
}

