/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.ope.OpeHelper;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShamblesAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shambles", new Pair[]{ImmutablePair.of((Object)"The user swaps place with the closest entity or block within the ROOM. Alt mode allows it to switch multiple entities within the ROOM.", null)});
    private static final ResourceLocation SHAMBLES_SINGLE_ICON = new ResourceLocation("mineminenomi", "textures/abilities/shambles.png");
    private static final ResourceLocation SHAMBLES_GROUP_ICON = new ResourceLocation("mineminenomi", "textures/abilities/shambles_group.png");
    private static final float COOLDOWN = 40.0f;
    public static final AbilityCore<ShamblesAbility> INSTANCE = new AbilityCore.Builder<ShamblesAbility>("Shambles", AbilityCategory.DEVIL_FRUITS, ShamblesAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f)).build();
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.SINGLE).addChangeModeEvent(this::onAltModeChange);
    private static final Predicate<Entity> SHAMBLES_LIST = target -> {
        if (target instanceof LightningEntity) {
            return false;
        }
        if (target instanceof SphereEntity) {
            return false;
        }
        return !(target.getEntity() instanceof AbilityProjectileEntity) || ((AbilityProjectileEntity)target.getEntity()).isPhysical();
    };

    public ShamblesAbility(AbilityCore<ShamblesAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.altModeComponent);
        super.addCanUseCheck(OpeHelper::hasRoomActive);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        RoomAbility roomAbility = AbilityDataCapability.get(entity).getEquippedAbility(RoomAbility.INSTANCE);
        boolean hadTarget = false;
        if (this.altModeComponent.getCurrentMode() == Mode.SINGLE) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 64.0);
            if (mop instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)mop;
                Entity target = entityRayTraceResult.func_216348_a();
                if (!roomAbility.isEntityInRoom(target)) {
                    return;
                }
                if (!SHAMBLES_LIST.test(target)) {
                    return;
                }
                float[] beforeCoords = new float[]{(float)entity.func_226277_ct_(), (float)entity.func_226278_cu_(), (float)entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A};
                entity.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
                entity.func_225653_b_(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                target.func_70012_b((double)beforeCoords[0], (double)beforeCoords[1], (double)beforeCoords[2], beforeCoords[3], beforeCoords[4]);
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
                entity.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
                hadTarget = true;
            } else if (mop instanceof BlockRayTraceResult) {
                BlockRayTraceResult result = (BlockRayTraceResult)mop;
                BlockPos pos = result.func_216350_a();
                BlockState state = entity.field_70170_p.func_180495_p(pos);
                BlockPos entityPos = entity.func_233580_cy_();
                BlockState entityPosState = entity.field_70170_p.func_180495_p(entityPos);
                boolean isInsideRoom = roomAbility.isPositionInRoom(pos);
                boolean isDestinationBanned = RestrictedBlockProtectionRule.INSTANCE.isBanned(state);
                boolean isOriginBanned = RestrictedBlockProtectionRule.INSTANCE.isBanned(entityPosState);
                if (isInsideRoom && !isDestinationBanned && !isOriginBanned) {
                    boolean a2;
                    BlockPos beforePos = entity.func_233580_cy_();
                    ProtectedAreasData protectedAreaData = ProtectedAreasData.get(entity.field_70170_p);
                    boolean a1 = protectedAreaData.isInsideRestrictedArea(beforePos.func_177958_n(), beforePos.func_177956_o(), beforePos.func_177952_p());
                    if (a1 != (a2 = protectedAreaData.isInsideRestrictedArea(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) {
                        return;
                    }
                    entity.func_70012_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
                    boolean b1 = AbilityHelper.placeBlockIfAllowed(entity, beforePos, state, 3, DefaultProtectionRules.AIR_CORE_FOLIAGE_ORE);
                    boolean b2 = AbilityHelper.placeBlockIfAllowed(entity, pos, Blocks.field_150350_a.func_176223_P(), 3, DefaultProtectionRules.AIR_CORE_FOLIAGE_ORE);
                    if (b1 && b2) {
                        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
                        hadTarget = true;
                    }
                }
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.GROUP) {
            BlockPos centerPos = roomAbility.getCenterBlock();
            Vector3d centerVec = new Vector3d((double)centerPos.func_177958_n(), (double)centerPos.func_177956_o(), (double)centerPos.func_177952_p());
            Predicate<Entity> groupCheck = ModEntityPredicates.getEnemyFactions(entity).and(SHAMBLES_LIST);
            List targets = WyHelper.getNearbyEntities(centerVec, (IWorld)entity.field_70170_p, (double)roomAbility.getROOMSize(), groupCheck, Entity.class);
            Collections.shuffle(targets);
            for (int i = 0; i < targets.size() && i < targets.size() && i + 1 < targets.size(); i += 2) {
                Entity target1 = (Entity)targets.get(i);
                Entity target2 = (Entity)targets.get(i + 1);
                if (!roomAbility.isPositionInRoom(target1.func_233580_cy_()) || !roomAbility.isPositionInRoom(target2.func_233580_cy_())) continue;
                float[] beforeCoords = new float[]{(float)target2.func_226277_ct_(), (float)target2.func_226278_cu_(), (float)target2.func_226281_cx_(), target2.field_70177_z, target2.field_70125_A};
                target2.func_70012_b(target1.func_226277_ct_(), target1.func_226278_cu_(), target1.func_226281_cx_(), target1.field_70177_z, target1.field_70125_A);
                target2.func_225653_b_(target1.func_226277_ct_(), target1.func_226278_cu_(), target1.func_226281_cx_());
                target1.func_70012_b((double)beforeCoords[0], (double)beforeCoords[1], (double)beforeCoords[2], beforeCoords[3], beforeCoords[4]);
                entity.field_70170_p.func_184133_a(null, target2.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
                entity.field_70170_p.func_184133_a(null, target1.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (targets.size() >= 2) {
                hadTarget = true;
            }
        }
        if (hadTarget) {
            this.cooldownComponent.startCooldown(entity, 40.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.SINGLE) {
            super.setDisplayIcon(SHAMBLES_SINGLE_ICON);
        } else if (mode == Mode.GROUP) {
            super.setDisplayIcon(SHAMBLES_GROUP_ICON);
        }
    }

    public static enum Mode {
        SINGLE,
        GROUP;

    }
}

