/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ori;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ori.AwaseBaoriProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class AwaseBaoriAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "awase_baori", new Pair[]{ImmutablePair.of((Object)"Launches a short range projectile that creates a small cage around the hit target.", null)});
    private static final int COOLDOWN = 200;
    private static final int HOLD_TIME = 100;
    public static final AbilityCore<AwaseBaoriAbility> INSTANCE = new AbilityCore.Builder<AwaseBaoriAbility>("Awase Baori", AbilityCategory.DEVIL_FRUITS, AwaseBaoriAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(100.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private AwaseBaoriProjectile proj;
    private List<BlockPos> placedBlocks = new ArrayList<BlockPos>();

    public AwaseBaoriAbility(AbilityCore<AwaseBaoriAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.proj = (AwaseBaoriProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
        entity.field_70170_p.func_217376_c((Entity)this.proj);
        this.proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 1.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.placedBlocks.isEmpty()) {
            if (this.proj != null && this.proj.getBlocks() != null) {
                this.placedBlocks = this.proj.getBlocks();
                return;
            }
            if (this.proj == null || !this.proj.func_70089_S()) {
                this.continuousComponent.stopContinuity(entity);
                return;
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.proj.func_70106_y();
        for (BlockPos pos : this.placedBlocks) {
            if (entity.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.ORI_BARS.get()) continue;
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.placedBlocks.clear();
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private AwaseBaoriProjectile createProjectile(LivingEntity entity) {
        AwaseBaoriProjectile proj = new AwaseBaoriProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

