/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pero;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CandyArmorAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "candy_armor", new Pair[]{ImmutablePair.of((Object)"Coats the user with a hard candy armor, which boosts defense, but reduces mobility.", null)});
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.CANDY_ARMOR).setColor(WyHelper.hexToRGB("#FFFFFF99")).build();
    private static final int HOLD_TIME = 300;
    private static final int MIN_COOLDOWN = 40;
    private static final float MAX_COOLDOWN = 200.0f;
    public static final AbilityCore<CandyArmorAbility> INSTANCE = new AbilityCore.Builder<CandyArmorAbility>("Candy Armor", AbilityCategory.DEVIL_FRUITS, CandyArmorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 200.0f), ContinuousComponent.getTooltip(300.0f), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier MINING_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("bde32ad3-5bf4-4b3b-8bf1-4947afbee0ad"), INSTANCE, "Candy Armor Mining Speed Modifier", (double)-0.05f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AbilityAttributeModifier MOVEMENT_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("df1e3c16-eaf5-4a65-8664-4ac073f14ed5"), INSTANCE, "Candy Armor Movement Speed Modifier", (double)-0.05f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(UUID.fromString("35c7d00c-2876-4ec5-801c-914677539ef5"), INSTANCE, "Candy Armor Armor Modifier", 18.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("bfc760c0-698d-4362-8bab-42b86ad008b9"), INSTANCE, "Candy Armor Toughness Modifier", 10.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public CandyArmorAbility(AbilityCore<CandyArmorAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.changeStatsComponent, this.skinOverlayComponent);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.MINING_SPEED, (AttributeModifier)MINING_SPEED_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_SPEED_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        float cooldown = Math.max(40.0f, this.continuousComponent.getContinueTime() / 1.5f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

