/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pero;

import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WallAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class CandyWallAbility
extends WallAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "candy_wall", new Pair[]{ImmutablePair.of((Object)"Creates a wall made out of candy in front of the user.", null)});
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE).build();
    private static final int COOLDOWN = 100;
    public static final AbilityCore<CandyWallAbility> INSTANCE = new AbilityCore.Builder<CandyWallAbility>("Candy Wall", AbilityCategory.DEVIL_FRUITS, CandyWallAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).build();

    public CandyWallAbility(AbilityCore<CandyWallAbility> core) {
        super(core);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    @Override
    public int getThickness() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 4;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Block getWallBlock() {
        return (Block)ModBlocks.CANDY.get();
    }

    @Override
    public BlockProtectionRule getGriefingRule() {
        return GRIEF_RULE;
    }

    @Override
    public boolean stopAfterUse() {
        return true;
    }
}

