/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class AmaNoMurakumoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ama_no_murakumo", new Pair[]{ImmutablePair.of((Object)"Focuses light in the user's hand to create a sword", null)});
    public static final AbilityCore<AmaNoMurakumoAbility> INSTANCE = new AbilityCore.Builder<AmaNoMurakumoAbility>("Ama no Murakumo", AbilityCategory.DEVIL_FRUITS, AmaNoMurakumoAbility::new).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.LIGHT).setSourceType(SourceType.SLASH).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    private final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent(this);

    public AmaNoMurakumoAbility(AbilityCore<AmaNoMurakumoAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.itemSpawnComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.spawnItem(entity, new ItemStack((IItemProvider)ModWeapons.AMA_NO_MURAKUMO.get()));
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.despawnItems(entity);
    }
}

