/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.pika.AmaterasuProjectile;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class LightAccelerationAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "light_acceleration", new Pair[]{ImmutablePair.of((Object)"The user accelerates its attacks by converting into light before impact", null)});
    private static final int COOLDOWN = 200;
    private static final int HOLD_TIME = 400;
    public static final AbilityCore<LightAccelerationAbility> INSTANCE = new AbilityCore.Builder<LightAccelerationAbility>("Light Acceleration", AbilityCategory.DEVIL_FRUITS, LightAccelerationAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(400.0f), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setSourceElement(SourceElement.LIGHT).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::duringContinuity).addEndEvent(this::onContinuityEnd);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent(this).addSwingEvent(0, this::onSwing);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addTryHitEvent(this::tryHitEvent);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setRenderType(AbilityOverlay.RenderType.ENERGY).setColor(new Color(255, 220, 0)).build();
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("ef9423e5-9be0-4223-a34a-538cb74d6e54"), INSTANCE, "Light Acceleration Strength Modifier", 10.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("1d78a133-8a0e-4b8f-8790-1360007d4741"), INSTANCE, "Light Acceleration Attack Speed Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private boolean hasSwung = false;
    private boolean hasTarget = false;

    public LightAccelerationAbility(AbilityCore<LightAccelerationAbility> core) {
        super(core);
        this.isNew = true;
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233823_f_, (AttributeModifier)STRENGTH_MODIFIER, entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b());
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b());
        super.addComponents(this.continuousComponent, this.swingTriggerComponent, this.changeStatsComponent, this.skinOverlayComponent, this.hitTriggerComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 400.0f);
    }

    private void onSwing(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.continuousComponent.isContinuous()) {
            this.hasTarget = false;
            this.hasSwung = true;
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void duringContinuity(LivingEntity entity, IAbility ability) {
        if (!this.hasTarget && this.hasSwung) {
            this.hasSwung = false;
            AmaterasuProjectile proj = new AmaterasuProjectile(entity.field_70170_p, entity);
            proj.setDamage(40.0f);
            proj.setArmorPiercing(0.5f);
            proj.setMaxLife(30);
            entity.field_70170_p.func_217376_c((Entity)proj);
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 5.0f, 1.0f);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.hasTarget = true;
        }
        return HitTriggerComponent.HitResult.PASS;
    }
}

