/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class YataNoKagamiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "yata_no_kagami", new Pair[]{ImmutablePair.of((Object)"The user forms light between his hands, and reflects it off any surface he wishes, instantly teleporting it towards where the light hit.", null)});
    private static final int COOLDOWN = 60;
    private static final float MAX_TELEPORT_DISTANCE = 200.0f;
    private static final float SAFE_TELEPORT_DISTANCE = 64.0f;
    private static final AbilityDescriptionLine.IDescriptionLine TELEPORT_TOOLTIP = (entity, ability) -> {
        AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_TELEPORT_DISTANCE, 64.0f).withUnit((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_BLOCKS);
        return statBuilder.build().getStatDescription();
    };
    public static final AbilityCore<YataNoKagamiAbility> INSTANCE = new AbilityCore.Builder<YataNoKagamiAbility>("Yata no Kagami", AbilityCategory.DEVIL_FRUITS, YataNoKagamiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f), TELEPORT_TOOLTIP).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private LightningEntity bolt;
    private boolean hasFallDamage = true;
    private boolean isCancelled = false;

    public YataNoKagamiAbility(AbilityCore<YataNoKagamiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.damageTakenComponent, this.animationComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (AbilityHelper.canUseMomentumAbilities(entity)) {
                this.chargeComponent.startCharging(entity, 30.0f);
            }
        } else {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.hasFallDamage = false;
        this.isCancelled = false;
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        BlockRayTraceResult trace = WyHelper.rayTraceBlocks((Entity)entity, 1.0);
        if (this.bolt == null) {
            Direction dir = Direction.func_176733_a((double)entity.field_70177_z);
            Vector3d hitVec = trace.func_216347_e().func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
            this.bolt = new LightningEntity((Entity)entity, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, entity.field_70177_z, entity.field_70125_A, 200.0f, 30.0f, this.getCore());
            this.bolt.setColor(new Color(252, 255, 22, 77));
            this.bolt.setMaxLife((int)(this.chargeComponent.getMaxChargeTime() * 1.2f));
            this.bolt.setDamage(0.0f);
            this.bolt.setSize(0.1f);
            this.bolt.setBranches(8);
            this.bolt.setSegments(1);
            this.bolt.setLightningMimic(false);
            entity.field_70170_p.func_217376_c((Entity)this.bolt);
        } else {
            Direction dir = Direction.func_176733_a((double)entity.field_70177_z);
            Vector3d hitVec = trace.func_216347_e().func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
            this.bolt.func_70012_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, entity.field_70177_z, entity.field_70125_A);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        AbilityHelper.slowEntityFall(entity, 2);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.PIKA_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.bolt != null) {
            this.bolt.func_70106_y();
            this.bolt = null;
        }
        if (!this.isCancelled) {
            float maxDistance = Math.max(50.0f, 200.0f - 200.0f * (1.0f - entity.func_110143_aJ() / entity.func_110138_aP()) * 2.0f);
            float safeDistance = Math.max(16.0f, 64.0f - 64.0f * (1.0f - entity.func_110143_aJ() / entity.func_110138_aP()) * 2.0f);
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, maxDistance);
            BlockPos blockpos = mop == null || mop.func_216346_c() == RayTraceResult.Type.MISS ? WyHelper.rayTraceBlockSafe(entity, safeDistance) : WyHelper.getClearPositionForPlayer(entity, mop.func_216350_a());
            if (blockpos == null) {
                blockpos = WyHelper.rayTraceBlockSafe(entity, safeDistance);
            }
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.YATA_NO_KAGAMI.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FLASH.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.YATA_NO_KAGAMI.get(), (Entity)entity, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            entity.func_184210_p();
            entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        if (damage >= 5.0f) {
            if (this.chargeComponent.isCharging()) {
                this.isCancelled = true;
                this.chargeComponent.stopCharging(entity);
            } else {
                this.disableComponent.startDisable(entity, 40.0f);
            }
        }
        return damage;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }
}

