/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryubrachiosaurus;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BrachioBomberAbility
extends DropHitAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "brachio_bomber", new Pair[]{ImmutablePair.of((Object)"Dives from a high place and lands on his opponent, crushing them under the user's weight.", null)});
    private static final int COOLDOWN = 300;
    private static final float DAMAGE = 20.0f;
    private static final float RANGE = 5.5f;
    public static final AbilityCore<BrachioBomberAbility> INSTANCE = new AbilityCore.Builder<BrachioBomberAbility>("Brachio Bomber", AbilityCategory.DEVIL_FRUITS, BrachioBomberAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), DealDamageComponent.getTooltip(20.0f), RangeComponent.getTooltip(5.5f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.BRACHIO_HEAVY.get(), (MorphInfo)ModMorphs.BRACHIO_GUARD.get());

    public BrachioBomberAbility(AbilityCore<BrachioBomberAbility> core) {
        super(core);
        this.addComponents(this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.requireMorphComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    @Override
    public void onLanding(LivingEntity entity) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GREAT_STOMP.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        int size = 7;
        if (((MorphInfo)ModMorphs.BRACHIO_GUARD.get()).isActive(entity)) {
            size = 15;
        } else if (((MorphInfo)ModMorphs.BRACHIO_HEAVY.get()).isActive(entity)) {
            this.animationComponent.stop(entity);
        }
        if (!entity.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), size);
            explosion.setDestroyBlocks(true);
            explosion.setStaticDamage(size * 2);
            explosion.doExplosion();
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 5.5f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 20.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        double jump = 1.3;
        if (((MorphInfo)ModMorphs.BRACHIO_GUARD.get()).isActive(entity)) {
            jump = 1.6;
        } else if (((MorphInfo)ModMorphs.BRACHIO_HEAVY.get()).isActive(entity)) {
            this.animationComponent.start(entity, ModAnimations.BELLY_FLOP);
        }
        Vector3d speed = WyHelper.propulsion(entity, 1.0, 1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, jump, speed.field_72449_c);
    }
}

