/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryupteranodon;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryupteranodon.PteranodonFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class PteranodonFlyPointAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "pteranodon_fly_point", new Pair[]{ImmutablePair.of((Object)"Transforms the user into an ancient pteranodon.", null)});
    public static final AbilityCore<PteranodonFlyPointAbility> INSTANCE = new AbilityCore.Builder<PteranodonFlyPointAbility>("Pteranodon Fly Point", AbilityCategory.DEVIL_FRUITS, PteranodonFlyPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(10.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Pteranodon Fly Point Speed Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Pteranodon Fly Point Armor Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Pteranodon Fly Point Strength Modifier", 12.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Pteranodon Fly Point Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);

    public PteranodonFlyPointAbility(AbilityCore<PteranodonFlyPointAbility> core) {
        super(core);
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)SPEED_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isMorphed);
        this.continuousComponent.addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        if (abilityDataProps == null) {
            return;
        }
        PropelledFlightAbility pteranodonFlightAbility = abilityDataProps.getPassiveAbility(PteranodonFlightAbility.INSTANCE);
        if (pteranodonFlightAbility != null && !pteranodonFlightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        if (abilityDataProps == null) {
            return;
        }
        PropelledFlightAbility pteranodonFlightAbility = abilityDataProps.getPassiveAbility(PteranodonFlightAbility.INSTANCE);
        if (pteranodonFlightAbility != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)entity);
        }
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.PTERA_FLY.get();
    }
}

