/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sniper;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.sniper.HissatsuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BowTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.HiNoToriBoshiProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.SniperProjectiles;

public class KaenBoshiAbility
extends Ability {
    private static final ResourceLocation ICON = new ResourceLocation("mineminenomi", "textures/abilities/hi_no_tori_boshi.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kaen_boshi", new Pair[]{ImmutablePair.of((Object)"Fires a flaming pellet that sets the target on fire", null)});
    private static final float COOLDOWN = 100.0f;
    public static final AbilityCore<KaenBoshiAbility> INSTANCE = new AbilityCore.Builder<KaenBoshiAbility>("Kaen Boshi", AbilityCategory.STYLE, KaenBoshiAbility::new).setIcon(ICON).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), ContinuousComponent.getTooltip()).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.FIRE).setSourceType(SourceType.BULLET).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this);
    private final BowTriggerComponent bowTriggerComponent = new BowTriggerComponent(this).addShootEvent(this::shoot);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public KaenBoshiAbility(AbilityCore<KaenBoshiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.bowTriggerComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    public boolean shoot(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            boolean isHitScan = HissatsuAbility.checkHitScan(entity);
            this.projectileComponent.setHitScan(isHitScan);
            this.projectileComponent.shoot(entity, 4.0f, 1.0f);
            this.continuousComponent.stopContinuity(entity);
            this.cooldownComponent.startCooldown(entity, 100.0f);
            return true;
        }
        return false;
    }

    public HiNoToriBoshiProjectile createProjectile(LivingEntity entity) {
        HiNoToriBoshiProjectile proj = new HiNoToriBoshiProjectile((EntityType)SniperProjectiles.KAEN_BOSHI.get(), entity.field_70170_p, entity, INSTANCE);
        proj.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        proj.setDamage(10.0f);
        return proj;
    }
}

