/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.toriphoenix.BlueBirdParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlueBirdAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "blue_bird", new Pair[]{ImmutablePair.of((Object)"The user builds up momentum through blue flames, to deliver a devastating kick.", null)});
    private static final int CHARGE_TIME = 20;
    private static final int HOLD_TIME = 10;
    private static final int COOLDOWN = 200;
    private static final int RANGE = 2;
    private static final int DAMAGE = 25;
    public static final AbilityCore<BlueBirdAbility> INSTANCE = new AbilityCore.Builder<BlueBirdAbility>("Blue Bird", AbilityCategory.DEVIL_FRUITS, BlueBirdAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(20.0f), DealDamageComponent.getTooltip(25.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private static final BlueBirdParticleEffect.Details DETAILS = new BlueBirdParticleEffect.Details();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PHOENIX_ASSAULT.get(), new MorphInfo[0]);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);

    public BlueBirdAbility(AbilityCore<BlueBirdAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.requireMorphComponent, this.chargeComponent, this.continuousComponent, this.animationComponent, this.rangeComponent, this.dealDamageComponent, this.hitTrackerComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        DETAILS.setMaxChargeTime(this.chargeComponent.getMaxChargeTime());
        DETAILS.setCurrentChargeTime(this.chargeComponent.getChargeTime());
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLUE_BIRD.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), DETAILS);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.PHOENIX_KICK);
        this.hitTrackerComponent.clearHits();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        float time = this.continuousComponent.getContinueTime();
        Vector3d velocity = entity.func_70040_Z().func_216369_h(new Vector3d(5.0 * ((double)time / 10.0), 5.0, 5.0 * ((double)time / 10.0)));
        AbilityHelper.setDeltaMovement((Entity)entity, velocity);
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 25.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

