/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SaiseiNoHonoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "saisei_no_hono", new Pair[]{ImmutablePair.of((Object)"Uses the blue flames to heal the target by hitting them. Using it while crouching will heal friendly entities around the user including the user themselves at the expense of a longer cooldown based on the number of healed entities.", null)});
    private static final TargetsPredicate TARGETS_CHECK = new TargetsPredicate().testFriendlyFaction();
    private static final float COOLDOWN = 300.0f;
    private static final int RANGE = 10;
    private static final int HEAL = 10;
    public static final AbilityCore<SaiseiNoHonoAbility> INSTANCE = new AbilityCore.Builder<SaiseiNoHonoAbility>("Saisei No Hono", AbilityCategory.DEVIL_FRUITS, SaiseiNoHonoAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(), HealComponent.getTooltip(10.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PHOENIX_ASSAULT.get(), new MorphInfo[0]);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::hitEvent).addTryHitEvent(this::tryHitEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final HealComponent healComponent = new HealComponent(this);
    private int healed;

    public SaiseiNoHonoAbility(AbilityCore<SaiseiNoHonoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.requireMorphComponent, this.continuousComponent, this.hitTriggerComponent, this.rangeComponent, this.healComponent);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.healed = 0;
        if (entity.func_213453_ef()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f, TARGETS_CHECK);
            targets.add(entity);
            int healed = 0;
            for (LivingEntity target : targets) {
                ++healed;
                this.healComponent.healTarget(entity, target, 10.0f);
                target.func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 1));
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLUE_FLAMES.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            }
            this.healed = Math.max(1, healed);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.TENSEI_NO_SOEN_2.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f + (float)(this.healed * 120));
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        source.setBypassFriendlyDamage();
        this.healComponent.healTarget(entity, target, 10.0f);
        target.func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 1));
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLUE_FLAMES.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.continuousComponent.stopContinuity(entity);
        return false;
    }
}

