/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.yami.BlackHoleAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSyncAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AbsorbedBlocksAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "absorbed_blocks", new Pair[]{ImmutablePair.of((Object)"Displays the total amount of blocks the user has absorbed.", null)});
    public static final AbilityCore<AbsorbedBlocksAbility> INSTANCE = new AbilityCore.Builder<AbsorbedBlocksAbility>("Absorbed Blocks", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, AbsorbedBlocksAbility::new).addDescriptionLine(DESCRIPTION).build();
    private List<BlockData> absorbedBlocks = new ArrayList<BlockData>();
    private int absorbedBlocksAmount = 0;
    private int previousAbsorbedBlocksAmount = -1;

    public AbsorbedBlocksAbility(AbilityCore<AbsorbedBlocksAbility> core) {
        super(core);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent(this, this::renderGauge);
            super.addComponents(gaugeComponent);
        }
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    public void onDuringPassive(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            this.absorbedBlocksAmount = this.absorbedBlocks.size();
            if (this.absorbedBlocksAmount != this.previousAbsorbedBlocksAmount) {
                WyNetwork.sendTo(new SSyncAbilityPacket(entity.func_145782_y(), this), (PlayerEntity)entity);
                this.previousAbsorbedBlocksAmount = this.absorbedBlocksAmount;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, AbsorbedBlocksAbility ability) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        RendererHelper.drawIcon(BlackHoleAbility.INSTANCE.getIcon(), matrixStack, posX, posY - 38, 0.0f, 32.0f, 32.0f);
        String strAbsorbedBlocksAmount = Integer.toString(ability.absorbedBlocksAmount);
        WyHelper.drawStringWithBorder(mc.field_71466_p, matrixStack, strAbsorbedBlocksAmount, posX + 15 - mc.field_71466_p.func_78256_a(strAbsorbedBlocksAmount) / 2, posY - 25, Color.WHITE.getRGB());
    }

    public List<BlockData> getAbsorbedBlocks() {
        return this.absorbedBlocks;
    }

    public List<BlockData> getCompressedBlocks() {
        return this.absorbedBlocks.stream().filter(blockData -> blockData.isCompressed()).collect(Collectors.toList());
    }

    public List<BlockData> getUncompressedBlocks() {
        return this.absorbedBlocks.stream().filter(blockData -> !blockData.isCompressed()).collect(Collectors.toList());
    }

    public void addAbsorbedBlock(BlockState blockState, BlockPos blockPos) {
        this.absorbedBlocks.add(new BlockData(blockState, blockPos));
    }

    public void removeAbsorbedBlock(BlockData blockData) {
        this.absorbedBlocks.remove(blockData);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74768_a("absorbedBlocksAmount", this.absorbedBlocksAmount);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.absorbedBlocksAmount = nbt.func_74762_e("absorbedBlocksAmount");
    }

    public static class BlockData {
        private BlockState blockState;
        private BlockPos blockPos;
        private boolean isCompressed = false;

        public BlockData(BlockState blockState, BlockPos blockPos) {
            this.blockState = blockState;
            this.blockPos = blockPos;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public void setCompressed(boolean flag) {
            this.isCompressed = flag;
        }
    }
}

