/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlackWorldAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "black_world", new Pair[]{ImmutablePair.of((Object)"The user spreads their power to the surroundings, blinding enemies and creating pillars of Darkness.", null)});
    private static final int COOLDOWN = 200;
    public static final AbilityCore<BlackWorldAbility> INSTANCE = new AbilityCore.Builder<BlackWorldAbility>("Black World", AbilityCategory.DEVIL_FRUITS, BlackWorldAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = AirBlockProtectionRule.INSTANCE;

    public BlackWorldAbility(AbilityCore<BlackWorldAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[0]);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLACK_WORLD.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        BlockState defaultDarknessState = ((Block)ModBlocks.DARKNESS.get()).func_176223_P();
        for (int i = 0; i < 12; ++i) {
            Vector3d vec = Vector3d.func_189986_a((float)0.0f, (float)entity.func_70681_au().nextInt(360)).func_72432_b().func_186678_a((double)(5 + entity.func_70681_au().nextInt(10)));
            for (int j = -5; j < 5; ++j) {
                AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177963_a(vec.field_72450_a, (double)j, vec.field_72449_c), defaultDarknessState, GRIEF_RULE);
                AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177963_a(vec.field_72450_a + 1.0, (double)j, vec.field_72449_c), defaultDarknessState, GRIEF_RULE);
                AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177963_a(vec.field_72450_a, (double)j, vec.field_72449_c + 1.0), defaultDarknessState, GRIEF_RULE);
                AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177963_a(vec.field_72450_a + 1.0, (double)j, vec.field_72449_c + 1.0), defaultDarknessState, GRIEF_RULE);
            }
        }
        List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 20.0, ModEntityPredicates.getEnemyFactions(entity));
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1, false, false));
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

