/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zoumammoth;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AncientStompAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ancient_stomp", new Pair[]{ImmutablePair.of((Object)"Stomps the ground multiple times creating shockwaves that deal damage to all nearby enemies.", null)});
    private static final int COOLDOWN = 200;
    private static final int RADIUS = 7;
    private static final int DAMAGE = 10;
    public static final AbilityCore<AncientStompAbility> INSTANCE = new AbilityCore.Builder<AncientStompAbility>("Ancient Stomp", AbilityCategory.DEVIL_FRUITS, AncientStompAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), DealDamageComponent.getTooltip(10.0f), RangeComponent.getTooltip(7.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addEndEvent(100, this::endContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(100, this::triggerRepeaterEvent).addStopEvent(100, this::stopRepeaterEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.MAMMOTH_GUARD.get(), new MorphInfo[0]);
    private Iterator<BlockPos> targetedBlocks;

    public AncientStompAbility(AbilityCore<AncientStompAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.rangeComponent, this.dealDamageComponent, this.requireMorphComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        Predicate<BlockPos> predicate = pos -> entity.field_70170_p.func_180495_p(pos.func_177984_a()).func_196958_f() && (double)pos.func_177956_o() > entity.func_226278_cu_() - 3.0;
        Vector3d look = entity.func_213303_ch().func_178787_e(entity.func_70040_Z().func_216372_d(7.0, 1.0, 7.0));
        BlockPos ogPos = new BlockPos(look.func_82615_a(), entity.func_226278_cu_(), look.func_82616_c());
        List<BlockPos> poses = WyHelper.getNearbyBlocks(ogPos, (IWorld)entity.field_70170_p, 7, predicate, (List<Block>)ImmutableList.of((Object)Blocks.field_150350_a));
        this.targetedBlocks = WyHelper.shuffle(poses).stream().limit(10L).iterator();
        this.repeaterComponent.start(entity, 12, 8);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        if (this.targetedBlocks == null || !this.targetedBlocks.hasNext()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        BlockPos stompPos = this.targetedBlocks.next();
        List<LivingEntity> list = this.rangeComponent.getTargetsInArea(entity, 7.0f);
        Iterator<LivingEntity> iter = list.iterator();
        ModDamageSource source = ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).markIndirectDamage();
        while (iter.hasNext()) {
            LivingEntity target = iter.next();
            if (!this.dealDamageComponent.hurtTarget(entity, target, 10.0f, source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0));
            AbilityHelper.setDeltaMovement((Entity)target, target.func_213322_ci().func_72441_c(0.0, 0.25, 0.0));
        }
        List<BlockPos> blocks = WyHelper.getNearbyBlocks(entity.func_233580_cy_(), (IWorld)entity.field_70170_p, 7, p -> FoliageBlockProtectionRule.INSTANCE.isApproved(entity.field_70170_p.func_180495_p(p)), (List<Block>)ImmutableList.of((Object)Blocks.field_150350_a));
        if (!entity.field_70170_p.field_72995_K) {
            for (BlockPos blockPos : blocks) {
                BlockState blockState = entity.field_70170_p.func_180495_p(blockPos);
                for (int i = 0; i < 150; ++i) {
                    double offsetX = WyHelper.randomDouble();
                    double offsetY = WyHelper.randomDouble();
                    double offsetZ = WyHelper.randomDouble();
                    ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), (double)blockPos.func_177958_n() + offsetX, (double)blockPos.func_177956_o() + offsetY, (double)blockPos.func_177952_p() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            BlockState blockState = entity.field_70170_p.func_180495_p(stompPos);
            if (blockState.func_185904_a().func_76220_a()) {
                for (int i = 0; i < 250; ++i) {
                    double x = WyHelper.randomDouble();
                    double z = WyHelper.randomDouble();
                    ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), (double)stompPos.func_177958_n() + WyHelper.randomWithRange(-3, 3) + x, (double)(stompPos.func_177956_o() + 1), (double)stompPos.func_177952_p() + WyHelper.randomWithRange(-3, 3) + z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility abiltiy) {
        this.continuousComponent.stopContinuity(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

