/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class AbareHimatsuriAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "abare_himatsuri", new Pair[]{ImmutablePair.of((Object)"Makes the user fly using gravity on the ground below you.", null)});
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 1200;
    public static final AbilityCore<AbareHimatsuriAbility> INSTANCE = new AbilityCore.Builder<AbareHimatsuriAbility>("Abare Himatsuri", AbilityCategory.DEVIL_FRUITS, AbareHimatsuriAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private boolean stateChanged = false;

    public AbareHimatsuriAbility(AbilityCore<AbareHimatsuriAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck((entity, ability) -> {
            if (AbilityHelper.isInCreativeOrSpectator(entity)) {
                return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_SUVIVAL_ONLY);
            }
            return AbilityUseResult.success();
        });
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_71075_bZ.field_75101_c = true;
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_70143_R = 0.0f;
            if (!AbilityHelper.canUseMomentumAbilities((LivingEntity)player)) {
                if (player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    this.stateChanged = true;
                }
            } else if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
                this.stateChanged = true;
            }
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
            boolean canFly = DevilFruitHelper.flyingAtMaxHeight((LivingEntity)player, 48.0);
            if (player.field_71075_bZ.field_75100_b) {
                DevilFruitHelper.vanillaFlightThreshold((LivingEntity)player, canFly ? 256 : (int)player.func_226278_cu_() - 1);
            }
            if (player.func_70051_ag()) {
                AbilityHelper.setDeltaMovement((Entity)player, player.func_213322_ci().func_216372_d(0.69, 1.0, 0.69));
                player.func_70031_b(false);
                this.stateChanged = true;
            }
            if (this.stateChanged) {
                this.stateChanged = false;
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
        }
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

