/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.zushi.GraviZoneAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class JigokuTabiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "jigoku_tabi", new Pair[]{ImmutablePair.of((Object)"Causes a powerful downward force of gravity, sending the enemies down in a crater. The longer its used the more damage it'll deal and the larger the crater will become.", null)});
    private static final int HOLD_TIME = 120;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 340;
    private static final int RANGE = 24;
    private static final int DEFAULT_FORCE = 4;
    private static final int FORCE_INCREASE = 60;
    private static final int MIN_DAMAGE = 8;
    private static final int MAX_DAMAGE = 12;
    public static final AbilityCore<JigokuTabiAbility> INSTANCE = new AbilityCore.Builder<JigokuTabiAbility>("Jigoku Tabi", AbilityCategory.DEVIL_FRUITS, JigokuTabiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 340.0f), ContinuousComponent.getTooltip(120.0f), RangeComponent.getTooltip(24.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(8.0f, 12.0f)).setSourceElement(SourceElement.GRAVITY).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private int force = 4;
    private Interval damageInterval = new Interval(20);
    private Interval addForceInterval = new Interval(60);

    public JigokuTabiAbility(AbilityCore<JigokuTabiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 120.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.force = 4;
        this.damageInterval.restartIntervalToZero();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 24.0f);
        ModDamageSource source = ModDamageSource.causeAbilityDamage(entity, this).bypassLogia().setPiercing(1.0f).setUnavoidable();
        for (LivingEntity target : targets) {
            AbilityHelper.setDeltaMovement((Entity)target, 0.0, target.func_213322_ci().field_72448_b - 4.0, 0.0);
            if (!this.damageInterval.canTick()) continue;
            EffectInstance instance = new EffectInstance(Effects.field_76421_d, 25, 5, false, false);
            target.func_195064_c(instance);
            this.dealDamageComponent.hurtTarget(entity, target, this.force * 2, source);
            GraviZoneAbility.gravityRing(target, 3, 2, false);
            AbilityHelper.createSphere(entity.field_70170_p, target.func_233580_cy_(), this.force, 2, false, Blocks.field_150350_a, 2, DefaultProtectionRules.CORE_FOLIAGE_ORE);
        }
        if (this.addForceInterval.canTick()) {
            ++this.force;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = 100.0f + this.continuousComponent.getContinueTime() * 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

