/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.zushi.GraviZoneAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.zushi.SagariNoRyuseiProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SagariNoRyuseiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sagari_no_ryusei", new Pair[]{ImmutablePair.of((Object)"Using gravity, the user pulls one (or rarely two) meteorites down on their enemies.", null)});
    private static final int COOLDOWN = 900;
    public static final AbilityCore<SagariNoRyuseiAbility> INSTANCE = new AbilityCore.Builder<SagariNoRyuseiAbility>("Sagari no Ryusei", AbilityCategory.DEVIL_FRUITS, SagariNoRyuseiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(900.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private int count;

    public SagariNoRyuseiAbility(AbilityCore<SagariNoRyuseiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.count = 0;
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM, 7);
        for (int i = 2; i < 16; i += 2) {
            GraviZoneAbility.gravityRing(entity, 4, i, false);
        }
        boolean has2nd = entity.func_70681_au().nextInt(3) == 0;
        SagariNoRyuseiProjectile proj1 = (SagariNoRyuseiProjectile)this.projectileComponent.getNewProjectile(entity);
        entity.field_70170_p.func_217376_c((Entity)proj1);
        if (has2nd) {
            ++this.count;
            SagariNoRyuseiProjectile proj2 = (SagariNoRyuseiProjectile)this.projectileComponent.getNewProjectile(entity);
            entity.field_70170_p.func_217376_c((Entity)proj2);
        }
        this.cooldownComponent.startCooldown(entity, 900.0f);
    }

    private SagariNoRyuseiProjectile createProjectile(LivingEntity entity) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
        double x = mop.func_216347_e().field_72450_a;
        double y = mop.func_216347_e().field_72448_b;
        double z = mop.func_216347_e().field_72449_c;
        float size = this.count == 0 ? (float)WyHelper.randomWithRange(24, 30) : (float)WyHelper.randomWithRange(8, 10);
        SagariNoRyuseiProjectile proj = new SagariNoRyuseiProjectile(entity.field_70170_p, entity);
        proj.setSize(size);
        proj.func_70107_b(x, y + 90.0, z);
        proj.field_70125_A = 0.0f;
        proj.field_70177_z = 0.0f;
        AbilityHelper.setDeltaMovement((Entity)proj, 0.0, -1.85, 0.0);
        return proj;
    }
}

