/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.animations.pteranodon;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;

public class PteraAssaultFlyAnimation
extends Animation<LivingEntity, BipedModel> {
    private static final double THRESHOLD_1 = 0.2;
    private static final double THRESHOLD_2 = 0.6;

    public PteraAssaultFlyAnimation(AnimationId<PteraAssaultFlyAnimation> animId) {
        super(animId);
        this.setAnimationSetup(this::setup);
        this.setAnimationAngles(this::angles);
    }

    public void angles(LivingEntity entity, BipedModel model, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        double posXDiff = Math.abs(entity.field_70169_q - entity.func_226277_ct_());
        double posZDiff = Math.abs(entity.field_70166_s - entity.func_226281_cx_());
        Vector3d look = entity.func_70040_Z();
        Vector3d oldPos = new Vector3d(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s);
        double movementDot = entity.func_213303_ch().func_178788_d(oldPos).func_72432_b().func_72430_b(look);
        float angles = 0.0f;
        if (movementDot > 0.0) {
            if (posXDiff >= 0.2 || posZDiff >= 0.2) {
                angles = (float)Math.toRadians(45.0);
                model.field_178722_k.field_78797_d = 8.0f;
                model.field_178721_j.field_78797_d = 8.0f;
                model.field_178722_k.field_78798_e = 8.0f;
                model.field_178721_j.field_78798_e = 8.0f;
                model.field_178721_j.field_78795_f = model.field_178722_k.field_78795_f = angles + 0.2f;
            }
            if (posXDiff >= 0.6 || posZDiff >= 0.6) {
                angles = (float)Math.toRadians(60.0);
                model.field_178722_k.field_78797_d = 5.8f;
                model.field_178721_j.field_78797_d = 5.8f;
                model.field_178722_k.field_78798_e = 10.0f;
                model.field_178721_j.field_78798_e = 10.0f;
                model.field_178721_j.field_78795_f = model.field_178722_k.field_78795_f = angles + 0.3f;
            }
        } else if (movementDot < 0.0) {
            if (posXDiff >= 0.2 || posZDiff >= 0.2) {
                angles = (float)Math.toRadians(-45.0);
                model.field_178722_k.field_78797_d = 8.0f;
                model.field_178721_j.field_78797_d = 8.0f;
                model.field_178722_k.field_78798_e = -8.0f;
                model.field_178721_j.field_78798_e = -8.0f;
                model.field_178721_j.field_78795_f = model.field_178722_k.field_78795_f = angles - 0.2f;
            }
            if (posXDiff >= 0.6 || posZDiff >= 0.6) {
                angles = (float)Math.toRadians(-60.0);
                model.field_178722_k.field_78797_d = 5.8f;
                model.field_178721_j.field_78797_d = 5.8f;
                model.field_178722_k.field_78798_e = -10.0f;
                model.field_178721_j.field_78798_e = -10.0f;
                model.field_178721_j.field_78795_f = model.field_178722_k.field_78795_f = angles - 0.3f;
            }
        }
        model.field_78115_e.field_78795_f = angles;
        if (entity.field_70733_aJ <= 0.0f) {
            model.field_178723_h.field_78795_f = angles;
            model.field_178724_i.field_78795_f = angles;
        }
    }

    public void setup(LivingEntity player, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float rotationYaw, float partialTicks) {
        double posXDiff = Math.abs(player.field_70169_q - player.func_226277_ct_());
        double posZDiff = Math.abs(player.field_70166_s - player.func_226281_cx_());
        double drop = 0.0;
        if (posXDiff >= 0.2 || posZDiff >= 0.2) {
            drop = 0.3;
        }
        if (posXDiff >= 0.6 || posZDiff >= 0.6) {
            drop = 0.4;
        }
        matrixStack.func_227861_a_(0.0, drop, 0.0);
    }
}

