/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlockQueue {
    private static Map<World, BlockQueue> queueMap = new ConcurrentHashMap<World, BlockQueue>();
    private Deque<BlockQueueData> queue = new ConcurrentLinkedDeque<BlockQueueData>();
    private final Supplier<Boolean> queueAction;
    private final ServerWorld world;
    private int speed = 50;
    private boolean isRunning = false;

    public void add(BlockQueueData block) {
        this.queue.add(block);
    }

    public void add(BlockPos pos, BlockState state) {
        this.add(new BlockQueueData(pos, state, 0));
    }

    public void add(BlockPos pos, BlockState state, int flag) {
        this.add(new BlockQueueData(pos, state, flag));
    }

    public BlockQueue(ServerWorld world) {
        this.world = world;
        this.queueAction = () -> {
            BlockQueueData block = null;
            boolean hasTime = true;
            long start = System.currentTimeMillis();
            while (hasTime && (block = this.queue.pollLast()) != null) {
                boolean canPlace;
                hasTime = System.currentTimeMillis() - start < (long)this.speed;
                boolean bl = canPlace = block.canPlaceCheck == null || block.canPlaceCheck.check((IWorld)world, block.pos, block.state);
                if (!canPlace) continue;
                int flag = block.flag;
                if (block.state.func_177230_c() instanceof FenceBlock) {
                    flag |= 0x10;
                }
                WyHelper.setBlockStateInChunk((World)world, block.pos, block.state, flag);
                if (block.tileEntity == null) continue;
                TileEntity blockEntity = world.func_175625_s(block.pos);
                block.tileEntity.accept(blockEntity);
            }
            return true;
        };
    }

    public BlockQueue setSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    public static BlockQueue getQueue(ServerWorld world) {
        if (!queueMap.containsKey(world)) {
            BlockQueue blockQueue = new BlockQueue(world);
            queueMap.put((World)world, blockQueue);
            return blockQueue;
        }
        return queueMap.get(world);
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isDone() {
        return this.isRunning && this.queue.size() <= 0;
    }

    public boolean hasNext() {
        return this.queue.size() > 0;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void tick() {
        if (this.isRunning && this.hasNext()) {
            this.queueAction.get();
        }
    }

    @FunctionalInterface
    public static interface ICanPlaceBlock {
        public boolean check(IWorld var1, BlockPos var2, BlockState var3);
    }

    public static class BlockQueueData {
        private final BlockPos pos;
        private final BlockState state;
        private final int flag;
        private Consumer<TileEntity> tileEntity = null;
        private ICanPlaceBlock canPlaceCheck = null;

        public BlockQueueData(BlockPos pos, BlockState state, int flag) {
            this.pos = pos;
            this.state = state;
            this.flag = flag;
        }

        public BlockQueueData setTileEntity(Consumer<TileEntity> consumer) {
            this.tileEntity = consumer;
            return this;
        }

        public BlockQueueData setCanPlaceCheck(ICanPlaceBlock canPlace) {
            this.canPlaceCheck = canPlace;
            return this;
        }
    }
}

