/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.charactercreator.FactionId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.RaceId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.StyleId;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ModRegistries {
    public static final IForgeRegistry<AbilityCore<?>> ABILITIES;
    public static final IForgeRegistry<MorphInfo> MORPHS;
    public static final IForgeRegistry<QuestId<?>> QUESTS;
    public static final IForgeRegistry<JollyRogerElement> JOLLY_ROGER_ELEMENTS;
    public static final IForgeRegistry<ChallengeCore<?>> CHALLENGES;
    public static final IForgeRegistry<ParticleEffect<?>> PARTICLE_EFFECTS;
    public static final IForgeRegistry<RaceId> RACES;
    public static final IForgeRegistry<FactionId> FACTIONS;
    public static final IForgeRegistry<StyleId> STYLES;
    public static final IForgeRegistry<Interaction> INTERACTIONS;

    public static <T extends IForgeRegistryEntry<T>> void make(ResourceLocation name, Class<T> type) {
        new RegistryBuilder().setName(name).setType(type).setMaxID(0x7FFFFFFE).create();
    }

    static {
        ModRegistries.make(new ResourceLocation("mineminenomi", "abilities"), AbilityCore.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "morphs"), MorphInfo.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "quests"), QuestId.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "jolly_roger_elements"), JollyRogerElement.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "challenges"), ChallengeCore.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "particle_effect"), ParticleEffect.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "race"), RaceId.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "faction"), FactionId.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "style"), StyleId.class);
        ModRegistries.make(new ResourceLocation("mineminenomi", "interactions"), Interaction.class);
        ABILITIES = RegistryManager.ACTIVE.getRegistry(AbilityCore.class);
        MORPHS = RegistryManager.ACTIVE.getRegistry(MorphInfo.class);
        QUESTS = RegistryManager.ACTIVE.getRegistry(QuestId.class);
        JOLLY_ROGER_ELEMENTS = RegistryManager.ACTIVE.getRegistry(JollyRogerElement.class);
        CHALLENGES = RegistryManager.ACTIVE.getRegistry(ChallengeCore.class);
        PARTICLE_EFFECTS = RegistryManager.ACTIVE.getRegistry(ParticleEffect.class);
        RACES = RegistryManager.ACTIVE.getRegistry(RaceId.class);
        FACTIONS = RegistryManager.ACTIVE.getRegistry(FactionId.class);
        STYLES = RegistryManager.ACTIVE.getRegistry(StyleId.class);
        INTERACTIONS = RegistryManager.ACTIVE.getRegistry(Interaction.class);
    }
}

