/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AbilityCore<A extends IAbility>
extends ForgeRegistryEntry<AbilityCore<?>>
implements Comparable<AbilityCore<?>> {
    private final String name;
    private final String id;
    private final AbilityCategory category;
    private final AbilityType type;
    private final IFactory<A> factory;
    private ResourceLocation icon;
    private Set<AbilityDescriptionLine> description;
    private SourceHakiNature sourceHakiNature;
    private ArrayList<SourceType> sourceTypes;
    private SourceElement sourceElement;
    private ICanUnlock unlockCheck;
    private AbilityCore<? extends ContinuousAbility>[] deps;
    private boolean isHidden = false;
    @Nullable
    private String i18nId;
    private ResourceLocation phantomKey;
    private IFormattableTextComponent localizedDisplayName;

    protected AbilityCore(String name, String id, AbilityCategory category, AbilityType type, IFactory<A> factory) {
        this.name = name;
        this.id = id;
        this.category = category;
        this.type = type;
        this.factory = factory;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public IFormattableTextComponent getLocalizedName() {
        String id = this.getLocalizationId();
        if (Strings.isNullOrEmpty((String)id)) {
            return new StringTextComponent(this.getUnlocalizedName());
        }
        return new TranslationTextComponent(id);
    }

    public String getLocalizationId() {
        if (this.i18nId == null) {
            ResourceLocation key = ModRegistries.ABILITIES.getKey((IForgeRegistryEntry)this);
            if (key == null && this.phantomKey != null) {
                key = this.phantomKey;
            }
            if (key != null) {
                this.i18nId = Util.func_200697_a((String)"ability", (ResourceLocation)key);
            }
        }
        return this.i18nId;
    }

    public AbilityCategory getCategory() {
        return this.category;
    }

    public AbilityType getType() {
        return this.type;
    }

    public IFactory<? extends A> getFactory() {
        return this.factory;
    }

    private void setUnlockCheck(ICanUnlock check) {
        this.unlockCheck = check;
    }

    public boolean canUnlock(LivingEntity entity) {
        if (this.unlockCheck == null) {
            return false;
        }
        return this.unlockCheck.canUnlock(entity);
    }

    public boolean hasUnlockCheck() {
        return this.unlockCheck != null;
    }

    private void setSourceHakiNature(SourceHakiNature sourceHakiNature) {
        this.sourceHakiNature = sourceHakiNature;
    }

    public SourceHakiNature getSourceHakiNature() {
        return this.sourceHakiNature;
    }

    private void setSourceTypes(SourceType ... sourceTypes) {
        this.sourceTypes = new ArrayList<SourceType>(Arrays.asList(sourceTypes));
    }

    public ArrayList<SourceType> getSourceTypes() {
        return new ArrayList<SourceType>(this.sourceTypes);
    }

    public boolean hasType(SourceType type) {
        boolean flag = false;
        for (SourceType t : this.sourceTypes) {
            if (!t.equals((Object)type)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void setSourceElement(SourceElement sourceElement) {
        this.sourceElement = sourceElement;
    }

    public SourceElement getSourceElement() {
        return this.sourceElement;
    }

    public void setDescription(Set<AbilityDescriptionLine> description) {
        this.description = description;
    }

    @Nullable
    public Set<AbilityDescriptionLine> getDescription() {
        return this.description;
    }

    @Deprecated
    protected void setDependencies(AbilityCore<? extends ContinuousAbility> ... deps) {
        this.deps = deps;
    }

    @Deprecated
    public void setIcon(ResourceLocation res) {
        this.icon = res;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Deprecated
    @Nullable
    public AbilityCore<? extends ContinuousAbility>[] getDependencies() {
        return this.deps;
    }

    @Deprecated
    public void setHidden() {
        this.isHidden = true;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isVisible() {
        return !this.isHidden();
    }

    private void setPhantomKey(ResourceLocation key) {
        this.phantomKey = key;
    }

    public A createAbility() {
        return this.factory.create(this);
    }

    @Nullable
    public static <A extends IAbility> AbilityCore<?> get(ResourceLocation res) {
        AbilityCore core = (AbilityCore)ModRegistries.ABILITIES.getValue(res);
        return core;
    }

    @Nullable
    public ResourceLocation getKey() {
        return ModRegistries.ABILITIES.getKey((IForgeRegistryEntry)this);
    }

    public String toString() {
        return this.getUnlocalizedName();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AbilityCore)) {
            return false;
        }
        AbilityCore otherCore = (AbilityCore)other;
        if (this.getRegistryName() == null || otherCore.getRegistryName() == null) {
            return false;
        }
        return this.getRegistryName().equals((Object)otherCore.getRegistryName());
    }

    @Override
    public int compareTo(AbilityCore<?> other) {
        if (other == null) {
            return 1;
        }
        String id = this.getLocalizedName().getString();
        String oid = other.getLocalizedName().getString();
        return id.compareToIgnoreCase(oid);
    }

    @FunctionalInterface
    public static interface ICanUnlock {
        public boolean canUnlock(LivingEntity var1);

        default public ICanUnlock and(ICanUnlock check) {
            return entity -> this.canUnlock(entity) && check.canUnlock(entity);
        }

        default public ICanUnlock or(ICanUnlock check) {
            return entity -> this.canUnlock(entity) || check.canUnlock(entity);
        }
    }

    public static interface IFactory<A extends IAbility> {
        public A create(AbilityCore<A> var1);
    }

    public static class Builder<A extends IAbility> {
        private final String name;
        private final String id;
        private final AbilityCategory category;
        private final AbilityType type;
        private final IFactory<A> factory;
        private Set<AbilityDescriptionLine> descriptionLines = new LinkedHashSet<AbilityDescriptionLine>();
        private SourceHakiNature sourceHakiNature = SourceHakiNature.UNKNOWN;
        private SourceType[] sourceTypes = new SourceType[]{SourceType.UNKNOWN};
        private SourceElement sourceElement = SourceElement.NONE;
        private ICanUnlock unlockCheck;
        private AbilityCore<? extends ContinuousAbility>[] deps;
        private boolean isHidden = false;
        private Set<Consumer<Builder<A>>> consumerExtensions = new LinkedHashSet<Consumer<Builder<A>>>();
        private ResourceLocation icon;
        private ResourceLocation phantomKey;

        public Builder(String name, AbilityCategory category, IFactory<A> factory) {
            this(name, category, AbilityType.ACTION, factory);
        }

        public Builder(String name, AbilityCategory category, AbilityType type, IFactory<A> factory) {
            this.name = name;
            this.id = WyHelper.getResourceName(name);
            this.category = category;
            this.type = type;
            this.factory = factory;
        }

        public Builder(String name, String id, AbilityCategory category, AbilityType type, IFactory<A> factory) {
            this.name = name;
            this.id = id;
            this.category = category;
            this.type = type;
            this.factory = factory;
        }

        public Builder<A> setUnlockCheck(ICanUnlock unlockCheck) {
            this.unlockCheck = unlockCheck;
            return this;
        }

        public Builder<A> setSourceHakiNature(SourceHakiNature hakiNature) {
            this.sourceHakiNature = hakiNature;
            return this;
        }

        public Builder<A> setSourceType(SourceType ... sourceTypes) {
            this.sourceTypes = sourceTypes;
            return this;
        }

        public Builder<A> setSourceElement(SourceElement sourceElement) {
            this.sourceElement = sourceElement;
            return this;
        }

        public Builder<A> setIcon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        @Deprecated
        public Builder<A> addDescriptionLine(String desc, Object ... args) {
            this.descriptionLines.add(AbilityDescriptionLine.of((ITextComponent)new TranslationTextComponent(desc, args), false));
            return this;
        }

        @Deprecated
        public Builder<A> addExtension(Consumer<Builder<A>> consumer) {
            this.consumerExtensions.add(consumer);
            return this;
        }

        public Builder<A> addDescriptionLine(AbilityDescriptionLine ... lines) {
            Collections.addAll(this.descriptionLines, lines);
            return this;
        }

        public Builder<A> addDescriptionLine(AbilityDescriptionLine.IDescriptionLine ... lines) {
            for (AbilityDescriptionLine.IDescriptionLine line : lines) {
                this.descriptionLines.add(AbilityDescriptionLine.of(line, false));
            }
            return this;
        }

        public Builder<A> addAdvancedDescriptionLine(AbilityDescriptionLine.IDescriptionLine ... lines) {
            for (AbilityDescriptionLine.IDescriptionLine line : lines) {
                this.descriptionLines.add(AbilityDescriptionLine.of(line, true));
            }
            return this;
        }

        public Builder<A> addDescriptionLine(ITextComponent ... components) {
            for (ITextComponent comp : components) {
                this.descriptionLines.add(AbilityDescriptionLine.of(comp, false));
            }
            return this;
        }

        @Deprecated
        public Builder<A> setDependencies(AbilityCore<? extends ContinuousAbility> ... deps) {
            this.deps = deps;
            return this;
        }

        public Builder<A> setHidden() {
            this.isHidden = true;
            return this;
        }

        public Builder<A> setPhantomKey(ResourceLocation key) {
            this.phantomKey = key;
            return this;
        }

        public AbilityCore<A> build() {
            AbilityCore<A> core = new AbilityCore<A>(this.name, this.id, this.category, this.type, this.factory);
            for (Consumer<Builder<A>> c : this.consumerExtensions) {
                c.accept(this);
            }
            LinkedHashSet<AbilityDescriptionLine> set = new LinkedHashSet<AbilityDescriptionLine>();
            for (AbilityDescriptionLine line : this.descriptionLines) {
                set.add(line);
            }
            core.setDescription(set);
            ((AbilityCore)core).setUnlockCheck(this.unlockCheck);
            ((AbilityCore)core).setSourceHakiNature(this.sourceHakiNature);
            ((AbilityCore)core).setSourceTypes(this.sourceTypes);
            ((AbilityCore)core).setSourceElement(this.sourceElement);
            core.setDependencies(this.deps);
            core.setIcon(this.icon);
            ((AbilityCore)core).setPhantomKey(this.phantomKey);
            if (this.isHidden) {
                core.setHidden();
            }
            return core;
        }
    }
}

