/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.time.Instant;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;

public class AbilityCoreUnlockWrapper<A extends IAbility> {
    private final AbilityCore<A> abilityCore;
    private final AbilityUnlock unlockedMethod;
    private final long unlockedRealTimestamp;
    private final long unlockedGameTimestamp;

    public AbilityCoreUnlockWrapper(LivingEntity entity, AbilityCore<A> abilityCore, AbilityUnlock unlockedMethod) {
        this.abilityCore = abilityCore;
        this.unlockedMethod = unlockedMethod;
        this.unlockedRealTimestamp = Instant.now().getEpochSecond();
        this.unlockedGameTimestamp = entity.field_70170_p.func_82737_E();
    }

    private AbilityCoreUnlockWrapper(AbilityCore<A> abilityCore, AbilityUnlock unlockedMethod, long unlockedRealTimestamp, long unlockedGameTimestamp) {
        this.abilityCore = abilityCore;
        this.unlockedMethod = unlockedMethod;
        this.unlockedRealTimestamp = unlockedRealTimestamp;
        this.unlockedGameTimestamp = unlockedGameTimestamp;
    }

    public AbilityCore<A> getAbilityCore() {
        return this.abilityCore;
    }

    public AbilityUnlock getUnlockType() {
        return this.unlockedMethod;
    }

    public long getRealTimestamp() {
        return this.unlockedRealTimestamp;
    }

    public long getGameTimestamp() {
        return this.unlockedGameTimestamp;
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.abilityCore.getRegistryName().toString());
        nbt.func_74778_a("unlockedMethod", this.unlockedMethod.name());
        nbt.func_74772_a("realTimestamp", this.unlockedRealTimestamp);
        nbt.func_74772_a("gameTimestamp", this.unlockedGameTimestamp);
        return nbt;
    }

    public static <A extends IAbility> AbilityCoreUnlockWrapper of(CompoundNBT nbt) {
        AbilityCore abilityCore = (AbilityCore)ModRegistries.ABILITIES.getValue(new ResourceLocation(nbt.func_74779_i("id")));
        AbilityUnlock unlockedMethod = AbilityUnlock.valueOf(nbt.func_74779_i("unlockedMethod"));
        long unlockedRealTimestamp = nbt.func_74763_f("realTimestamp");
        long unlockedGameTimestamp = nbt.func_74763_f("gameTimestamp");
        AbilityCoreUnlockWrapper<A> details = new AbilityCoreUnlockWrapper<A>(abilityCore, unlockedMethod, unlockedRealTimestamp, unlockedGameTimestamp);
        return details;
    }
}

