/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.awt.Color;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AbilityOverlay {
    private int id;
    private ResourceLocation texture = null;
    private RenderType renderType = RenderType.NORMAL;
    private Color color = WyHelper.hexToRGB("#FFFFFFFF");
    private OverlayPart overlayPart = OverlayPart.BODY;

    private AbilityOverlay() {
        this.id = new Random().nextInt();
    }

    private AbilityOverlay setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    private AbilityOverlay setColor(Color color) {
        this.color = color;
        return this;
    }

    private AbilityOverlay setRenderType(RenderType type) {
        this.renderType = type;
        return this;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Color getColor() {
        return this.color;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    private void setOverlayPart(OverlayPart part) {
        this.overlayPart = part;
    }

    public OverlayPart getOverlayPart() {
        return this.overlayPart;
    }

    public int hashCode() {
        int result = this.id ^ this.id >>> 32;
        result = 31 * result + (this.texture == null ? 0 : this.texture.hashCode());
        result = 31 * result + this.color.hashCode();
        result = 31 * result + this.overlayPart.hashCode();
        result = 31 * result + this.renderType.hashCode();
        return result;
    }

    public static class Builder {
        private ResourceLocation texture = null;
        private RenderType renderType = RenderType.NORMAL;
        private Color color = WyHelper.hexToRGB("#FFFFFFFF");
        private OverlayPart overlayPart = OverlayPart.BODY;

        public Builder setTexture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public Builder setColor(Color color) {
            this.color = color;
            return this;
        }

        public Builder setColor(String hex) {
            this.color = WyHelper.hexToRGB(hex);
            return this;
        }

        public Builder setRenderType(RenderType type) {
            this.renderType = type;
            return this;
        }

        public Builder setOverlayPart(OverlayPart part) {
            this.overlayPart = part;
            return this;
        }

        public AbilityOverlay build() {
            AbilityOverlay overlay = new AbilityOverlay();
            overlay.setTexture(this.texture);
            overlay.setColor(this.color);
            overlay.setRenderType(this.renderType);
            overlay.setOverlayPart(this.overlayPart);
            return overlay;
        }
    }

    public static enum OverlayPart {
        BODY,
        LIMB,
        HEAD,
        ARM,
        LEG;

    }

    public static enum RenderType {
        NORMAL,
        ENERGY;

    }
}

