/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import com.google.common.base.Strings;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public abstract class MorphAbility2
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(110, this::startContinuityEvent).addTickEvent(110, this::tickContinuityEvent).addEndEvent(110, this::stopContinuityEvent);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    protected final MorphComponent morphComponent = new MorphComponent(this);

    public MorphAbility2(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.statsComponent, this.morphComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        String currentMorph = DevilFruitCapability.get(entity).getZoanPoint();
        if (!Strings.isNullOrEmpty((String)currentMorph) && !currentMorph.equals(this.getTransformation().getForm())) {
            Set abls = AbilityDataCapability.get(entity).getEquippedAbilitiesWith(ModAbilityKeys.MORPH, ModAbilityKeys.CONTINUOUS);
            for (IAbility abl : abls) {
                if (abl == this) continue;
                abl.getComponent(ModAbilityKeys.CONTINUOUS).get().stopContinuity(entity);
            }
        }
        this.continuousComponent.triggerContinuity(entity, this.getContinuityHoldTime());
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        float initialHealthPercentage = entity.func_110143_aJ() / entity.func_110138_aP();
        this.morphComponent.startMorph(entity, this.getTransformation());
        this.statsComponent.applyModifiers(entity);
        float newHealth = entity.func_110138_aP() * initialHealthPercentage;
        entity.func_70606_j(newHealth);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!this.morphComponent.isMorphed()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        float initialHealthPercentage = entity.func_110143_aJ() / entity.func_110138_aP();
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        float newHealth = entity.func_110138_aP() * initialHealthPercentage;
        entity.func_70606_j(newHealth);
    }

    public abstract MorphInfo getTransformation();

    public float getContinuityHoldTime() {
        return -1.0f;
    }

    public float getCooldownTicks() {
        return 10.0f;
    }
}

