/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DisableComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SForceStopChargingPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStartChargingPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ChargeComponent
extends AbilityComponent<IAbility> {
    private static final UUID MAX_CHARGE_BONUS_MANAGER_UUID = UUID.fromString("75b893d9-9d02-457e-9c35-02e468586fcc");
    private static final TranslationTextComponent CHARGE_STAT = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_STAT_NAME_CHARGE);
    private boolean isCharging;
    private float maxChargeTime;
    private float chargeTime;
    private boolean isCancelable;
    private Predicate<ChargeComponent> isCancelableTest;
    private final PriorityEventPool<IStartChargingEvent> startChargeEvents = new PriorityEventPool();
    private final PriorityEventPool<IDuringChargingEvent> tickChargeEvents = new PriorityEventPool();
    private final PriorityEventPool<IEndChargingEvent> stopChargeEvents = new PriorityEventPool();
    private final BonusManager maxChargeBonusManager = new BonusManager(MAX_CHARGE_BONUS_MANAGER_UUID);

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float ticks) {
        return ChargeComponent.getTooltip(ticks, ticks);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float min, float max) {
        return (e, a) -> {
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)CHARGE_STAT, Math.round(min / 20.0f), Math.round(max / 20.0f)).withUnit((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_SECONDS);
            return statBuilder.build().getStatDescription();
        };
    }

    public ChargeComponent(IAbility ability) {
        this(ability, false);
        this.addBonusManager(this.maxChargeBonusManager);
    }

    public ChargeComponent(IAbility ability, boolean isCancelable) {
        super(ModAbilityKeys.CHARGE, ability);
        this.isCancelable = isCancelable;
        this.isCancelableTest = comp -> true;
    }

    public ChargeComponent(IAbility ability, Predicate<ChargeComponent> isCancelableTest) {
        super(ModAbilityKeys.CHARGE, ability);
        this.isCancelable = true;
        this.isCancelableTest = isCancelableTest;
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> component.addPreRenderEvent(201, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (this.isCharging()) {
                component.setMaxValue(this.maxChargeTime);
                component.setCurrentValue(this.chargeTime);
                if (ClientConfig.INSTANCE.isDisplayInPercentage()) {
                    float percentage = this.chargeTime / this.maxChargeTime * 100.0f;
                    percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)100.0f);
                    String percentageText = String.format("%.0f", Float.valueOf(percentage)) + "%";
                    component.setDisplayText(percentageText);
                }
                component.setSlotColor(1.0f, 1.0f, 0.0f);
            }
        }));
    }

    @Override
    protected void doTick(LivingEntity entity) {
        if (this.getAbility().hasComponent(ModAbilityKeys.DISABLE) && this.getAbility().getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
            return;
        }
        this.getAbility().getComponent(ModAbilityKeys.ALT_MODE).ifPresent(component -> component.setDisabled(this.isCharging()));
        if (this.isCharging()) {
            ProtectedAreasData worldData;
            ProtectedArea area;
            if (entity.func_70644_a((Effect)ModEffects.IN_EVENT.get())) {
                this.forceStopCharging(entity);
                return;
            }
            if (!entity.field_70170_p.field_72995_K && (area = (worldData = ProtectedAreasData.get(entity.field_70170_p)).getProtectedArea(entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177956_o(), entity.func_233580_cy_().func_177952_p())) != null && !area.canUseAbility(this.getAbility().getCore())) {
                this.forceStopCharging(entity);
                return;
            }
            if (this.chargeTime >= this.maxChargeTime) {
                this.stopCharging(entity);
                return;
            }
            ModifiableAttributeInstance inst = entity.func_110148_a((Attribute)ModAttributes.TIME_PROGRESSION.get());
            double timeProgression = 1.0;
            if (inst != null) {
                timeProgression = inst.func_111126_e();
            }
            this.chargeTime = (float)((double)this.chargeTime + (double)super.getTpsFactor() * timeProgression);
            int loops = Math.max(1, (int)super.getTpsFactor());
            for (int i = 0; i < loops; ++i) {
                this.tickChargeEvents.dispatch(event -> event.duringCharging(entity, (IAbility)this.getAbility()));
            }
        }
    }

    public ChargeComponent addStartEvent(IStartChargingEvent event) {
        this.startChargeEvents.addEvent(event);
        return this;
    }

    public ChargeComponent addStartEvent(int priority, IStartChargingEvent event) {
        this.startChargeEvents.addEvent(priority, event);
        return this;
    }

    public ChargeComponent addTickEvent(IDuringChargingEvent event) {
        this.tickChargeEvents.addEvent(event);
        return this;
    }

    public ChargeComponent addTickEvent(int priority, IDuringChargingEvent event) {
        this.tickChargeEvents.addEvent(priority, event);
        return this;
    }

    public ChargeComponent addEndEvent(IEndChargingEvent event) {
        this.stopChargeEvents.addEvent(event);
        return this;
    }

    public ChargeComponent addEndEvent(int priority, IEndChargingEvent event) {
        this.stopChargeEvents.addEvent(priority, event);
        return this;
    }

    public void startCharging(LivingEntity user, float maxChargeTime) {
        this.ensureIsRegistered();
        if (this.isCharging()) {
            if (this.isCancelable() && this.isCancelableTest.test(this)) {
                this.stopCharging(user);
            }
            return;
        }
        Optional<CooldownComponent> cooldownComponent = this.getAbility().getComponent(ModAbilityKeys.COOLDOWN);
        if (cooldownComponent.isPresent() && cooldownComponent.get().isOnCooldown()) {
            return;
        }
        Optional<DisableComponent> disableComponent = this.getAbility().getComponent(ModAbilityKeys.DISABLE);
        if (disableComponent.isPresent() && disableComponent.get().isDisabled()) {
            return;
        }
        Optional<PoolComponent> poolComponent = this.getAbility().getComponent(ModAbilityKeys.POOL);
        if (poolComponent.isPresent() && poolComponent.get().isPoolInUse()) {
            return;
        }
        float newMaxChargeTime = Math.max(1.0f, maxChargeTime);
        this.maxChargeTime = newMaxChargeTime = this.maxChargeBonusManager.applyBonus(newMaxChargeTime);
        this.chargeTime = 0.0f;
        this.isCharging = true;
        if (!user.field_70170_p.field_72995_K) {
            poolComponent.ifPresent(c -> c.startPoolInUse(user));
        }
        this.startChargeEvents.dispatch(event -> event.startCharging(user, (IAbility)this.getAbility()));
        if (!user.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStartChargingPacket(user, (IAbility)this.getAbility(), maxChargeTime), (Entity)user);
        }
    }

    public void stopCharging(LivingEntity entity) {
        this.stopChargeEvents.dispatch(event -> event.endCharging(entity, (IAbility)this.getAbility()));
        this.forceStopCharging(entity);
    }

    public void forceStopCharging(LivingEntity entity) {
        this.isCharging = false;
        this.chargeTime = 0.0f;
        this.maxChargeTime = 0.0f;
        this.getAbility().getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(c -> c.resetDecoration());
        if (!entity.field_70170_p.field_72995_K) {
            this.getAbility().getComponent(ModAbilityKeys.POOL).ifPresent(c -> c.stopPoolInUse(entity));
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SForceStopChargingPacket(entity, (IAbility)this.getAbility()), (Entity)entity);
        }
    }

    public boolean isCharging() {
        return this.isCharging;
    }

    public float getMaxChargeTime() {
        return this.maxChargeTime;
    }

    public float getChargeTime() {
        return this.chargeTime;
    }

    public float getChargePercentage() {
        float per = this.chargeTime / this.maxChargeTime;
        if (Float.isNaN(per)) {
            return 0.0f;
        }
        return per;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public BonusManager getMaxChargeBonusManager() {
        return this.maxChargeBonusManager;
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74776_a("chargeTime", this.chargeTime);
        nbt.func_74776_a("maxChargeTime", this.maxChargeTime);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.chargeTime = nbt.func_74760_g("chargeTime");
        this.maxChargeTime = nbt.func_74760_g("maxChargeTime");
        if (this.chargeTime > 0.0f) {
            this.isCharging = true;
        }
    }

    @FunctionalInterface
    public static interface IEndChargingEvent {
        public void endCharging(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IDuringChargingEvent {
        public void duringCharging(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IStartChargingEvent {
        public void startCharging(LivingEntity var1, IAbility var2);
    }
}

