/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.LinkedList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class DealDamageComponent
extends AbilityComponent<IAbility> {
    private static final UUID DAMAGE_BONUS_MANAGER_UUID = UUID.fromString("f4ac25c4-ef9f-4537-8471-406a02737308");
    private static final UUID STYLE_BONUS = UUID.fromString("dd55f409-9924-4cca-afbe-522462884d71");
    private static final int TARGETS_SIZE = 10;
    private LinkedList<LivingEntity> lastTargets = new LinkedList();
    private final BonusManager bonusManager = new BonusManager(DAMAGE_BONUS_MANAGER_UUID);
    private DamageSource damageSource;

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float damage) {
        return DealDamageComponent.getTooltip(damage, damage);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float min, float max) {
        return (e, a) -> {
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_DAMAGE, min, max);
            a.getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> {
                float maxBonusDamage;
                float minBonusDamage = comp.getBonusManager().applyBonus(min) - min;
                float diffBonus = minBonusDamage + (maxBonusDamage = comp.getBonusManager().applyBonus(max) - max);
                AbilityStat.AbilityStatType bonusType = diffBonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (diffBonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                statBuilder.withBonus(minBonusDamage, maxBonusDamage, bonusType);
            });
            return statBuilder.build().getStatDescription();
        };
    }

    public DealDamageComponent(IAbility ability) {
        super(ModAbilityKeys.DAMAGE, ability);
        this.addBonusManager(this.bonusManager);
    }

    public boolean hurtTarget(LivingEntity attacker, LivingEntity target, float damage) {
        return this.hurtTarget(attacker, target, damage, this.getDamageSource(attacker));
    }

    public boolean hurtTarget(LivingEntity attacker, LivingEntity target, float damage, DamageSource source) {
        if (ModMain.hasShitInstalled() && source instanceof ModDamageSource && ((ModDamageSource)source).isIgnored()) {
            return false;
        }
        this.ensureIsRegistered();
        float finalDamage = this.calculateFinalDamage(attacker, damage);
        if (target.func_70097_a(source, finalDamage)) {
            if (target.func_70089_S()) {
                if (this.lastTargets.size() >= 0 && this.lastTargets.size() == 10) {
                    this.lastTargets.remove();
                }
                this.lastTargets.add(target);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    public DamageSource getDamageSource(LivingEntity attacker) {
        if (this.damageSource == null) {
            this.damageSource = AbilityDamageSource.causeAbilityDamage(attacker, super.getAbility().getCore());
        }
        return this.damageSource;
    }

    private float getDamageMultiplier(LivingEntity entity) {
        return (float)EntityStatsCapability.get(entity).getDamageMultiplier();
    }

    private float calculateFinalDamage(LivingEntity entity, float damage) {
        float bonusDamage = this.calculateBonusDamage(entity, this.getAbility().getCore(), damage);
        return bonusDamage * this.getDamageMultiplier(entity);
    }

    private float calculateBonusDamage(LivingEntity entity, AbilityCore ability, float baseDamage) {
        boolean hasSniperBonus;
        this.bonusManager.removeBonus(STYLE_BONUS);
        boolean isSlash = ability.hasType(SourceType.SLASH);
        boolean isBlunt = ability.hasType(SourceType.BLUNT);
        boolean isProj = ability.hasType(SourceType.PROJECTILE);
        boolean hasSlashBonus = (isSlash || isBlunt) && !entity.func_184614_ca().func_190926_b() && ItemsHelper.isSword(entity.func_184614_ca());
        boolean bl = hasSniperBonus = isProj && !entity.func_184614_ca().func_190926_b() && ItemsHelper.isBow(entity.func_184614_ca());
        if (hasSlashBonus) {
            this.bonusManager.addBonus(STYLE_BONUS, "Swordsman Fighting Style Bonus", BonusOperation.ADD, ItemsHelper.getItemDamage(entity.func_184614_ca()));
        }
        return this.bonusManager.applyBonus(baseDamage);
    }

    @Nullable
    public LivingEntity getLastTarget() {
        try {
            return this.lastTargets.getLast();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public LivingEntity getLastNTarget(int nth) {
        try {
            return this.lastTargets.get(nth);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public BonusManager getBonusManager() {
        return this.bonusManager;
    }
}

