/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStartDisablePacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStopDisablePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class DisableComponent
extends AbilityComponent<IAbility> {
    private boolean isDisabled;
    private float startDisableTime;
    private float disableTime;
    private boolean isInfinite;
    private final PriorityEventPool<IStartDisableEvent> startDisableEvents = new PriorityEventPool();
    private final PriorityEventPool<IEndDisableEvent> stopDisableEvents = new PriorityEventPool();

    public DisableComponent(IAbility ability) {
        super(ModAbilityKeys.DISABLE, ability);
        this.setTickRate(1);
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> {
            component.addPreRenderEvent(1000, (entity, minecraft, matrix, x, y, partialTicks) -> {
                if (this.isDisabled()) {
                    component.setMaxValue(this.startDisableTime);
                    component.setCurrentValue(this.disableTime);
                    if (ClientConfig.INSTANCE.isDisplayInPercentage()) {
                        float percentage = this.disableTime / this.startDisableTime * 100.0f;
                        percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)100.0f);
                        String percentageText = String.format("%.0f", Float.valueOf(percentage)) + "%";
                        component.setDisplayText(percentageText);
                    }
                    component.setSlotColor(0.0f, 0.0f, 0.0f);
                    component.setIconColor(0.4f, 0.4f, 0.4f);
                }
            });
            component.addPostRenderEvent(1000, (entity, minecraft, matrix, x, y, partialTicks) -> {
                if (this.isDisabled()) {
                    RendererHelper.drawIcon(ModResources.DISABLED_ABILITY, matrix, x + 4.0f, y + 4.0f, 0.0f, 16.0f, 16.0f);
                    minecraft.func_110434_K().func_110577_a(ModResources.WIDGETS);
                }
            });
        });
    }

    public DisableComponent addStartEvent(IStartDisableEvent event) {
        this.startDisableEvents.addEvent(event);
        return this;
    }

    public DisableComponent addStartEvent(int priority, IStartDisableEvent event) {
        this.startDisableEvents.addEvent(priority, event);
        return this;
    }

    public DisableComponent addEndEvent(IEndDisableEvent event) {
        this.stopDisableEvents.addEvent(event);
        return this;
    }

    public DisableComponent addEndEvent(int priority, IEndDisableEvent event) {
        this.stopDisableEvents.addEvent(priority, event);
        return this;
    }

    @Override
    protected void doTick(LivingEntity entity) {
        this.getAbility().getComponent(ModAbilityKeys.ALT_MODE).ifPresent(component -> component.setDisabled(this.isDisabled()));
        if (this.isDisabled()) {
            if (this.disableTime > 0.0f) {
                ModifiableAttributeInstance inst = entity.func_110148_a((Attribute)ModAttributes.TIME_PROGRESSION.get());
                double timeProgression = 1.0;
                if (inst != null) {
                    timeProgression = inst.func_111126_e();
                }
                this.disableTime = (float)((double)this.disableTime - 1.0 * timeProgression);
            } else if (this.disableTime <= 0.0f && !this.isInfinite) {
                this.stopDisable(entity);
                return;
            }
        }
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public float getStartDisableTime() {
        return this.startDisableTime;
    }

    public float getDisableTime() {
        return this.disableTime;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public void startDisable(LivingEntity entity, float time) {
        this.ensureIsRegistered();
        if (this.isDisabled()) {
            return;
        }
        this.isInfinite = time < 0.0f;
        this.startDisableTime = time;
        this.disableTime = time;
        this.isDisabled = true;
        this.startDisableEvents.dispatch(event -> event.startDisable(entity, (IAbility)this.getAbility()));
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStartDisablePacket(entity, (IAbility)this.getAbility(), time), (Entity)entity);
        }
    }

    public void stopDisable(LivingEntity entity) {
        if (!this.isDisabled()) {
            return;
        }
        this.stopDisableEvents.dispatch(event -> event.endDisable(entity, (IAbility)this.getAbility()));
        this.disableTime = 0.0f;
        this.isDisabled = false;
        this.getAbility().getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(c -> c.resetDecoration());
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStopDisablePacket(entity, (IAbility)this.getAbility()), (Entity)entity);
        }
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74776_a("disableTime", this.disableTime);
        nbt.func_74776_a("startDisableTime", this.startDisableTime);
        nbt.func_74757_a("isInfinite", this.isInfinite);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.disableTime = nbt.func_74760_g("disableTime");
        this.startDisableTime = nbt.func_74760_g("startDisableTime");
        this.isInfinite = nbt.func_74767_n("isInfinite");
        if (this.disableTime > 0.0f) {
            this.isDisabled = true;
        }
    }

    @FunctionalInterface
    public static interface IEndDisableEvent {
        public void endDisable(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IStartDisableEvent {
        public void startDisable(LivingEntity var1, IAbility var2);
    }
}

