/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SPinCameraPacket;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUnpinCameraPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class GrabEntityComponent
extends AbilityComponent<IAbility> {
    private LivingEntity grabbedEntity = null;
    private boolean handleTargetCamera = false;
    private boolean handleTargetPosition = false;
    private boolean handleTargetPulling = false;
    private float heldDistance = 1.0f;
    private float startHealth;
    private boolean cameraPinned;
    private double previousDistance;
    private final PriorityEventPool<IOnGrabEvent> grabEvents = new PriorityEventPool();
    private final PriorityEventPool<IOnPullStartEvent> pullStartEvents = new PriorityEventPool();
    private final PriorityEventPool<IOnPullTickEvent> pullTickEvents = new PriorityEventPool();
    private final PriorityEventPool<IOnPullEndEvent> pullEndEvents = new PriorityEventPool();
    private final PriorityEventPool<IOnReleaseEvent> releaseEvents = new PriorityEventPool();
    private GrabState state = GrabState.IDLE;

    public GrabEntityComponent(IAbility ability, boolean handleTargetCamera, boolean handleTargetPosition, float heldDistance) {
        this(ability, handleTargetCamera, handleTargetPosition, false, heldDistance);
    }

    public GrabEntityComponent(IAbility ability, boolean handleTargetCamera, boolean handleTargetPosition, boolean handleTargetPulling, float heldDistance) {
        super(ModAbilityKeys.GRAB, ability);
        this.handleTargetCamera = handleTargetCamera;
        this.handleTargetPosition = handleTargetPosition;
        this.handleTargetPulling = handleTargetPulling;
        this.heldDistance = heldDistance;
    }

    public GrabEntityComponent addGrabEvent(IOnGrabEvent event) {
        this.grabEvents.addEvent(100, event);
        return this;
    }

    public GrabEntityComponent addGrabEvent(int priority, IOnGrabEvent event) {
        this.grabEvents.addEvent(priority, event);
        return this;
    }

    public GrabEntityComponent addPullStartEvent(IOnPullStartEvent event) {
        this.pullStartEvents.addEvent(100, event);
        return this;
    }

    public GrabEntityComponent addPullStartEvent(int priority, IOnPullStartEvent event) {
        this.pullStartEvents.addEvent(priority, event);
        return this;
    }

    public GrabEntityComponent addPullTickEvent(IOnPullTickEvent event) {
        this.pullTickEvents.addEvent(100, event);
        return this;
    }

    public GrabEntityComponent addPullTickEvent(int priority, IOnPullTickEvent event) {
        this.pullTickEvents.addEvent(priority, event);
        return this;
    }

    public GrabEntityComponent addPullEndEvent(IOnPullEndEvent event) {
        this.pullEndEvents.addEvent(100, event);
        return this;
    }

    public GrabEntityComponent addPullEndEvent(int priority, IOnPullEndEvent event) {
        this.pullEndEvents.addEvent(priority, event);
        return this;
    }

    public GrabEntityComponent addReleaseEvent(IOnReleaseEvent event) {
        this.releaseEvents.addEvent(100, event);
        return this;
    }

    public GrabEntityComponent addReleaseEvent(int priority, IOnReleaseEvent event) {
        this.releaseEvents.addEvent(priority, event);
        return this;
    }

    @Override
    public void doTick(LivingEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.canContinueGrab(entity)) {
            if (this.state == GrabState.PULLING && this.handleTargetPulling) {
                this.grabbedEntity.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
                Vector3d difference = entity.func_174824_e(1.0f).func_72441_c(0.0, -1.0, 0.0).func_178788_d(this.grabbedEntity.func_213303_ch());
                double distance = Math.abs(entity.func_174824_e(1.0f).func_72438_d(this.grabbedEntity.func_213303_ch()));
                if (distance > this.previousDistance + 2.0) {
                    this.release(entity);
                    return;
                }
                this.previousDistance = distance;
                double length = MathHelper.func_76133_a((double)(difference.field_72450_a * difference.field_72450_a + difference.field_72449_c * difference.field_72449_c));
                double safeDifferenceY = difference.field_72448_b != 0.0 ? 1.0 / Math.abs(difference.field_72448_b) : 0.0;
                difference = difference.func_216372_d(1.0 / length, safeDifferenceY, 1.0 / length).func_186678_a(0.1);
                AbilityHelper.setDeltaMovement((Entity)this.grabbedEntity, this.grabbedEntity.func_213322_ci().func_178787_e(difference));
                float reach = (float)entity.func_233637_b_((Attribute)ModAttributes.ATTACK_RANGE.get()) + 3.0f;
                if (this.isTargetInRange(entity, reach, entity.func_213311_cf() / 2.0f + 0.1f)) {
                    this.stopPulling(entity);
                } else {
                    this.pullTickEvents.dispatch(event -> event.pullTick(entity, (IAbility)super.getAbility()));
                }
            }
            if (this.state == GrabState.GRABBED) {
                if (this.handleTargetCamera && !this.cameraPinned && this.grabbedEntity instanceof ServerPlayerEntity) {
                    WyNetwork.sendTo(SPinCameraPacket.pinFixed(), (PlayerEntity)((ServerPlayerEntity)this.grabbedEntity));
                    this.cameraPinned = true;
                }
                if (this.handleTargetPosition) {
                    this.grabbedEntity.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
                    Vector3d lookVec = entity.func_70040_Z().func_72432_b();
                    Vector3d pos = new Vector3d(lookVec.field_72450_a * (double)this.heldDistance, (double)entity.func_70047_e() - 1.0 + lookVec.field_72448_b * (double)this.heldDistance, lookVec.field_72449_c * (double)this.heldDistance);
                    AbilityHelper.setDeltaMovement((Entity)this.grabbedEntity, entity.func_213303_ch().func_178787_e(pos).func_178788_d(this.grabbedEntity.func_213303_ch()), true);
                    this.grabbedEntity.field_70143_R = 0.0f;
                }
            }
        } else if (this.grabbedEntity != null) {
            if (this.state == GrabState.PULLING) {
                this.stopPulling(entity);
            }
            this.release(entity);
        }
    }

    public void triggerPulling(LivingEntity entity) {
        if (this.state == GrabState.PULLING) {
            this.stopPulling(entity);
        } else {
            this.startPulling(entity);
        }
    }

    public void startPulling(LivingEntity entity) {
        this.state = GrabState.PULLING;
        this.pullStartEvents.dispatch(event -> event.pullStart(entity, (IAbility)super.getAbility()));
    }

    public void stopPulling(LivingEntity entity) {
        this.state = GrabState.GRABBED;
        this.pullEndEvents.dispatch(event -> event.pullEnd(entity, (IAbility)super.getAbility()));
    }

    public void throwTarget(LivingEntity entity, double horizontalPower, double verticalPower) {
        this.state = GrabState.THROWN;
        if (this.canContinueGrab(entity)) {
            this.grabbedEntity.func_195063_d((Effect)ModEffects.GRABBED.get());
            Vector3d diff = entity.func_213303_ch().func_178788_d(this.grabbedEntity.func_213303_ch()).func_72432_b().func_216372_d(-horizontalPower, -verticalPower, -horizontalPower);
            AbilityHelper.setDeltaMovement((Entity)this.grabbedEntity, diff);
        }
    }

    public void release(LivingEntity entity) {
        this.state = GrabState.IDLE;
        if (this.grabbedEntity != null && this.grabbedEntity.func_70089_S()) {
            this.releaseEvents.dispatch(event -> event.release(entity, this.grabbedEntity, (IAbility)this.getAbility()));
            if (this.grabbedEntity instanceof ServerPlayerEntity) {
                WyNetwork.sendTo(new SUnpinCameraPacket(), (PlayerEntity)((ServerPlayerEntity)this.grabbedEntity));
            }
        }
        this.grabbedEntity = null;
    }

    public boolean grabManually(LivingEntity entity, LivingEntity target) {
        this.ensureIsRegistered();
        if (target != null && target.func_70089_S() && !AbilityHelper.isTargetBlocking(entity, target)) {
            boolean flag;
            boolean bl = flag = !this.grabEvents.dispatchCancelable(event -> !event.grab(entity, target, (IAbility)this.getAbility()));
            if (flag) {
                this.grabbedEntity = target;
                this.previousDistance = Math.abs(entity.func_174824_e(1.0f).func_72438_d(this.grabbedEntity.func_213303_ch()));
                this.cameraPinned = false;
                this.startHealth = entity.func_110143_aJ();
                this.state = GrabState.GRABBED;
                return true;
            }
        }
        return false;
    }

    public boolean isTargetInRange(LivingEntity entity) {
        return this.isTargetInRange(entity, 3.0f, 0.4f);
    }

    public boolean isTargetInRange(LivingEntity entity, float distance, float size) {
        float reach = (float)Math.sqrt(AttributeHelper.getSquaredAttackRangeDistance(entity, distance));
        boolean targetInRange = TargetHelper.getEntitiesInArea(entity, entity.func_233580_cy_(), (double)reach, (double)entity.func_213302_cg(), size, null, LivingEntity.class).stream().anyMatch(target -> target.equals((Object)this.grabbedEntity));
        return targetInRange;
    }

    public boolean grabNearest(LivingEntity entity) {
        double reach = Math.sqrt(AttributeHelper.getSquaredAttackRangeDistance(entity, 3.0));
        return this.grabNearest(entity, (float)reach, 0.4f, true);
    }

    public boolean grabNearest(LivingEntity entity, boolean sendFailMessage) {
        double reach = Math.sqrt(AttributeHelper.getSquaredAttackRangeDistance(entity, 3.0));
        return this.grabNearest(entity, (float)reach, 0.4f, sendFailMessage);
    }

    public boolean grabNearest(LivingEntity entity, float distance, float size) {
        return this.grabNearest(entity, distance, size, true);
    }

    public boolean grabNearest(LivingEntity entity, float distance, float size, boolean sendFailMessage) {
        boolean flag;
        this.ensureIsRegistered();
        LivingEntity target = AbilityHelper.canGrab(entity, distance, size, sendFailMessage);
        boolean bl = flag = !this.grabEvents.dispatchCancelable(event -> !event.grab(entity, target, (IAbility)this.getAbility()));
        if (flag && target != null && target.func_70089_S()) {
            this.grabbedEntity = target;
            this.previousDistance = Math.abs(entity.func_174824_e(1.0f).func_72438_d(this.grabbedEntity.func_213303_ch()));
            this.cameraPinned = false;
            this.startHealth = entity.func_110143_aJ();
            this.state = GrabState.GRABBED;
            return true;
        }
        return false;
    }

    public boolean canContinueGrab(LivingEntity entity) {
        if (this.grabbedEntity == null || !this.grabbedEntity.func_70089_S()) {
            return false;
        }
        if (AbilityHelper.isDodging(this.grabbedEntity)) {
            return false;
        }
        if (AbilityHelper.isLogiaBlocking((Entity)entity, this.grabbedEntity)) {
            return false;
        }
        return !(entity.func_110143_aJ() < this.startHealth - 10.0f);
    }

    @Nullable
    public LivingEntity getGrabbedEntity() {
        return this.grabbedEntity;
    }

    public boolean hasGrabbedEntity() {
        return this.grabbedEntity != null && this.grabbedEntity.func_70089_S();
    }

    public static boolean hasGrabbed(LivingEntity entity, IAbility ability) {
        IAbilityData props = (IAbilityData)AbilityDataCapability.getLazy(entity).orElse(null);
        if (props == null) {
            return false;
        }
        for (IAbility abl : props.getEquippedAndPassiveAbilities()) {
            if (!abl.hasComponent(ModAbilityKeys.GRAB) || abl.equals(ability)) continue;
            boolean isOnCooldown = abl.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> comp.isOnCooldown()).orElse(false);
            boolean isDisabled = abl.getComponent(ModAbilityKeys.DISABLE).map(comp -> comp.isDisabled()).orElse(false);
            if (isOnCooldown || isDisabled || !abl.getComponent(ModAbilityKeys.GRAB).get().hasGrabbedEntity()) continue;
            return true;
        }
        return false;
    }

    public GrabState getState() {
        return this.state;
    }

    public void setState(GrabState state) {
        this.state = state;
    }

    public static enum GrabState {
        IDLE,
        PULLING,
        GRABBED,
        THROWN;

    }

    @FunctionalInterface
    public static interface IOnReleaseEvent {
        public void release(LivingEntity var1, LivingEntity var2, IAbility var3);
    }

    @FunctionalInterface
    public static interface IOnPullEndEvent {
        public void pullEnd(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IOnPullTickEvent {
        public void pullTick(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IOnPullStartEvent {
        public void pullStart(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IOnGrabEvent {
        public boolean grab(LivingEntity var1, LivingEntity var2, IAbility var3);
    }
}

