/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class HitTrackerComponent
extends AbilityComponent<IAbility> {
    private Set<Entity> hits = new HashSet<Entity>();
    private Set<UUID> hitsUUIDs = new HashSet<UUID>();

    public HitTrackerComponent(IAbility ability) {
        super(ModAbilityKeys.HIT_TRACKER, ability);
    }

    public void clearHits() {
        this.hits.clear();
        this.hitsUUIDs.clear();
    }

    public boolean canHit(Entity target) {
        this.ensureIsRegistered();
        if (this.hits.contains(target)) {
            return false;
        }
        this.hits.add(target);
        this.hitsUUIDs.add(target.func_110124_au());
        return true;
    }

    public Set<Entity> getHits() {
        return this.hits;
    }

    public Set<UUID> getHitsUUIDs() {
        return this.hitsUUIDs;
    }

    @Override
    protected void doTick(LivingEntity entity) {
    }
}

