/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class ItemSpawnComponent
extends AbilityComponent<IAbility> {
    public static final String SPAWN_TAG = "spawnedByAbility";
    private List<ItemStack> trackedStacks = new ArrayList<ItemStack>();
    private boolean isActive;
    private final PriorityEventPool<IMissingItemEvent> missingItemEvents = new PriorityEventPool();

    public ItemSpawnComponent(IAbility ability) {
        super(ModAbilityKeys.ITEM_SPAWN, ability);
        this.setTickRate(5);
    }

    public ItemSpawnComponent addMissingItemEvent(int priority, IMissingItemEvent event) {
        this.missingItemEvents.addEvent(priority, event);
        return this;
    }

    @Override
    public void doTick(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K && this.isActive && this.missingItemEvents.countEventsInPool() > 0L && !this.trackedStacks.isEmpty()) {
            for (ItemStack stack : this.trackedStacks) {
                if (!stack.func_190926_b()) continue;
                this.missingItemEvents.dispatch(event -> event.missingItem(entity, (IAbility)this.getAbility()));
                return;
            }
        }
    }

    private List<ItemStack> getTrackedItems() {
        return this.trackedStacks;
    }

    public void spawnItem(LivingEntity entity, ItemStack stack) {
        this.spawnItem(entity, stack, EquipmentSlotType.MAINHAND, false);
    }

    public void spawnItem(LivingEntity entity, ItemStack stack, @Nullable EquipmentSlotType slot, boolean forceSlot) {
        this.ensureIsRegistered();
        this.isActive = true;
        ItemStack itemStack = entity.func_184582_a(slot);
        if (itemStack.func_190926_b()) {
            entity.func_184201_a(slot, stack);
            this.trackedStacks.add(stack);
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_191521_c(stack);
            this.trackedStacks.add(stack);
        }
    }

    public void despawnItems(LivingEntity entity) {
        this.isActive = false;
        if (this.trackedStacks.size() > 0) {
            for (ItemStack stack : this.trackedStacks) {
                ItemsHelper.removeItemStackFromInventory(entity, stack);
            }
        }
        this.trackedStacks.clear();
    }

    public boolean isActive() {
        return this.isActive;
    }

    @FunctionalInterface
    public static interface IMissingItemEvent {
        public void missingItem(LivingEntity var1, IAbility var2);
    }
}

