/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class RequireMorphComponent
extends AbilityComponent<IAbility> {
    private MorphInfo[] morphs = new MorphInfo[0];
    private Interval checkInterval = new Interval(10);

    public static AbilityDescriptionLine.IDescriptionLine<IAbility> getTooltip() {
        return (entity, ability) -> {
            TranslationTextComponent tooltip = null;
            Optional<RequireMorphComponent> comp = ability.getComponent(ModAbilityKeys.REQUIRE_MORPH);
            if (comp.isPresent()) {
                if (comp.get().morphs.length == 1) {
                    tooltip = new TranslationTextComponent(ModI18n.ABILITY_DEPENDENCY_SINGLE_ACTIVE, new Object[]{"\u00a7a" + comp.get().morphs[0].getDisplayName() + "\u00a7r"});
                } else if (comp.get().morphs.length > 1) {
                    tooltip = new TranslationTextComponent(ModI18n.ABILITY_DEPENDENCY_DOUBLE_ACTIVE, new Object[]{"\u00a7a" + comp.get().morphs[0].getDisplayName() + "\u00a7r", "\u00a7a" + comp.get().morphs[1].getDisplayName() + "\u00a7r"});
                }
            }
            return tooltip;
        };
    }

    public RequireMorphComponent(IAbility ability, MorphInfo mainMorph, MorphInfo ... infos) {
        super(ModAbilityKeys.REQUIRE_MORPH, ability);
        this.morphs = new MorphInfo[infos.length + 1];
        this.morphs[0] = mainMorph;
        int i = 1;
        MorphInfo[] morphInfoArray = infos;
        int n = morphInfoArray.length;
        for (int j = 0; j < n; ++j) {
            MorphInfo morph;
            this.morphs[i] = morph = morphInfoArray[j];
            ++i;
        }
    }

    @Override
    protected void doTick(LivingEntity entity) {
        Optional<ContinuousComponent> comp;
        if (this.getAbility().hasComponent(ModAbilityKeys.CONTINUOUS) && (comp = this.getAbility().getComponent(ModAbilityKeys.CONTINUOUS)).isPresent() && comp.get().isContinuous() && this.checkInterval.canTick() && !this.checkRequirements(entity)) {
            comp.get().stopContinuity(entity);
        }
    }

    @Override
    public void postInit(IAbility iability) {
        if (iability instanceof Ability) {
            Ability abl = (Ability)iability;
            abl.addCanUseCheck((entity, ability) -> AbilityHelper.canUseMorphAbility(entity, abl, this.morphs));
        } else if (iability instanceof PassiveAbility2) {
            PassiveAbility2 abl = (PassiveAbility2)iability;
            abl.addCanUseCheck((entity, ability) -> AbilityHelper.canUseMorphAbility(entity, abl, this.morphs));
        }
    }

    public boolean checkRequirements(LivingEntity entity) {
        boolean result = false;
        for (MorphInfo morph : this.morphs) {
            if (!DevilFruitCapability.get(entity).hasMorphInQueue(morph)) continue;
            result = true;
            break;
        }
        return result;
    }
}

