/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;

public class ChallengeInfo {
    private static final ImmutableList<LivingEntity> EMPTY_GROUP = ImmutableList.of();
    @Nullable
    private InProgressChallenge challengeData;

    public ChallengeDifficulty getDifficulty() {
        if (this.challengeData == null) {
            return ChallengeDifficulty.STANDARD;
        }
        return this.challengeData.getCore().getDifficulty();
    }

    public List<LivingEntity> getChallengerGroup() {
        if (this.challengeData == null) {
            return EMPTY_GROUP;
        }
        return this.challengeData.getGroup();
    }

    public boolean isDifficultyStandard() {
        return this.getDifficulty() == ChallengeDifficulty.STANDARD;
    }

    public boolean isDifficultyHard() {
        return this.getDifficulty() == ChallengeDifficulty.HARD;
    }

    public boolean isDifficultyUltimate() {
        return this.getDifficulty() == ChallengeDifficulty.ULTIMATE;
    }

    public float getScaling() {
        float scale = (this.getChallengerGroup().size() - 1) * 50 + this.getDifficulty().ordinal() * 75;
        scale = Math.min(scale, 300.0f);
        return scale / 300.0f;
    }

    public void setInProgressChallenge(@Nullable InProgressChallenge data) {
        this.challengeData = data;
    }

    @Nullable
    public InProgressChallenge getInProgressChallengeData() {
        return this.challengeData;
    }
}

