/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import java.util.function.Function;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;

public class ChallengeTeleporter
implements ITeleporter {
    private InProgressChallenge challenge;
    private int spawnId = 0;
    private boolean toChallenge = true;

    public ChallengeTeleporter(InProgressChallenge challenge) {
        this.challenge = challenge;
    }

    public void teleportToChallengeWorld(Entity entity) {
        this.toChallenge = true;
        entity.changeDimension(this.challenge.getShard(), (ITeleporter)this);
    }

    public void teleportToHomeWorld(Entity entity) {
        this.toChallenge = false;
        entity.changeDimension(this.getTargetWorld(entity), (ITeleporter)this);
    }

    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        if (this.toChallenge) {
            ChallengeArena.SpawnPosition pos = this.challenge.getChallengerPosition().getChallengerSpawnPos(this.spawnId, this.challenge);
            ++this.spawnId;
            Vector3d vecPos = new Vector3d((double)pos.getPos().func_177958_n(), (double)pos.getPos().func_177956_o(), (double)pos.getPos().func_177952_p());
            PortalInfo info = new PortalInfo(vecPos, Vector3d.field_186680_a, pos.getYaw(), pos.getPitch());
            return info;
        }
        ServerWorld spawnWorld = this.getTargetWorld(entity);
        BlockPos spawnPos = null;
        if (CommonConfig.INSTANCE.isReturnToSafetyEnabled()) {
            if (entity instanceof ServerPlayerEntity) {
                spawnPos = ((ServerPlayerEntity)entity).func_241140_K_();
            }
            if (spawnPos == null) {
                spawnPos = spawnWorld.func_241135_u_();
            }
        } else {
            spawnPos = this.challenge.getReturnPosition();
        }
        Vector3d vecPos = new Vector3d((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
        PortalInfo info = new PortalInfo(vecPos, Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        return info;
    }

    private ServerWorld getTargetWorld(Entity entity) {
        if (this.toChallenge) {
            return this.challenge.getShard();
        }
        ServerWorld spawnWorld = CommonConfig.INSTANCE.isReturnToSafetyEnabled() ? entity.func_184102_h().func_241755_D_() : entity.func_184102_h().func_71218_a(this.challenge.getReturnDimension());
        return spawnWorld;
    }
}

