/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.charactercreator;

import com.google.common.base.Joiner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.charactercreator.ICharacterCreatorEntry;

public enum CharacterCreatorEntry {
    FACTION(ModRegistries.FACTIONS),
    RACE(ModRegistries.RACES),
    STYLE(ModRegistries.STYLES);

    private final IForgeRegistry<? extends ICharacterCreatorEntry> registry;

    private CharacterCreatorEntry(IForgeRegistry<? extends ICharacterCreatorEntry> registry) {
        this.registry = registry;
    }

    public ITextComponent getLocalizedTitle(ResourceLocation location) {
        return new TranslationTextComponent(Joiner.on((char)'.').join((Object)this.registry.getRegistryName().func_110623_a(), (Object)location.func_110624_b(), new Object[]{location.func_110623_a()}));
    }

    public ICharacterCreatorEntry getInfo(int id) {
        return this.getEntries()[id];
    }

    private ICharacterCreatorEntry[] getEntries() {
        return (ICharacterCreatorEntry[])this.registry.getValues().stream().filter(rec$ -> ((ICharacterCreatorEntry)rec$).isInBook()).sorted((e1, e2) -> e1.getBookOrder() - e2.getBookOrder()).toArray(ICharacterCreatorEntry[]::new);
    }

    public int getSize() {
        return this.getEntries().length;
    }
}

