/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.damagesource;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.brawler.GenkotsuMeteorAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiInfusionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModItems;

public class AbilityDamageSource
extends ModEntityDamageSource {
    private AbilityCore<? extends IAbility> ability;
    private boolean isProjectileSource = false;
    private LivingEntity thrower;

    public AbilityDamageSource(String damageType, Entity source, AbilityCore<? extends IAbility> ability) {
        super(damageType, source);
        this.ability = ability;
        this.setSourceTypes(ability.getSourceTypes());
        this.setHakiNature(ability.getSourceHakiNature());
        this.setSourceElement(ability.getSourceElement());
    }

    public AbilityDamageSource(String damageType, AbilityProjectileEntity source, AbilityCore<? extends IAbility> ability) {
        super(damageType, (Entity)source);
        this.ability = ability;
        this.setSourceTypes(ability.getSourceTypes());
        this.setHakiNature(ability.getSourceHakiNature());
        this.setSourceElement(ability.getSourceElement());
        this.isProjectileSource = true;
        this.thrower = source.getThrower();
    }

    public AbilityCore<? extends IAbility> getAbilitySource() {
        return this.ability;
    }

    @Nullable
    public Entity func_76364_f() {
        return this.entity;
    }

    @Override
    @Nullable
    public Entity func_76346_g() {
        if (this.isProjectileSource && this.thrower != null) {
            return this.thrower;
        }
        return super.func_76346_g();
    }

    @Override
    public ITextComponent func_151519_b(LivingEntity entityLivingBaseIn) {
        String s = "death.attack." + this.field_76373_n;
        return new TranslationTextComponent(s, new Object[]{entityLivingBaseIn.func_145748_c_(), this.func_76346_g().func_145748_c_(), this.ability.getUnlocalizedName()});
    }

    public String toString() {
        return "AbilityDamageSource (" + this.field_76373_n + ") from ability: " + this.ability.getUnlocalizedName();
    }

    public float getBonusDamage(float damage) {
        boolean hasSniperBonus;
        boolean hasFistBonus;
        float originalAmount = damage;
        if (this.func_76346_g() == null || !(this.func_76346_g() instanceof LivingEntity)) {
            return damage;
        }
        LivingEntity attacker = (LivingEntity)this.func_76346_g();
        if (attacker == null || damage <= 0.0f) {
            return 0.0f;
        }
        boolean hasSlashBonus = (this.isSlash() || this.isBlunt()) && !attacker.func_184614_ca().func_190926_b() && ItemsHelper.isSword(attacker.func_184614_ca());
        boolean bl = hasFistBonus = this.isFistDamage() && attacker.func_184614_ca().func_190926_b();
        if (EntityStatsCapability.get(attacker).isBrawler() && attacker.func_184614_ca().func_77973_b() == ModItems.CANNON_BALL.get() && this.getAbilitySource().equals(GenkotsuMeteorAbility.INSTANCE)) {
            hasFistBonus = true;
        }
        boolean bl2 = hasSniperBonus = this.func_76352_a() && !attacker.func_184614_ca().func_190926_b() && ItemsHelper.isBow(attacker.func_184614_ca());
        if (hasSlashBonus) {
            damage += ItemsHelper.getItemDamage(attacker.func_184614_ca());
        } else if (hasFistBonus) {
            ModifiableAttributeInstance punchAttr = attacker.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get());
            ModifiableAttributeInstance attackDamageAttr = attacker.func_110148_a(Attributes.field_233823_f_);
            if (punchAttr != null) {
                damage = (float)((double)damage + punchAttr.func_111126_e());
            }
            if (attackDamageAttr != null) {
                damage = (float)((double)damage + attackDamageAttr.func_111126_e());
            }
        }
        if (!hasFistBonus) {
            boolean hasInfusion;
            boolean hasHardeningActive = HakiHelper.hasHardeningActive(attacker, false, false);
            boolean hasImbuingActive = HakiHelper.hasImbuingActive(attacker, false, false);
            boolean hasAdvancedBusoActive = HakiHelper.hasAdvancedBusoActive(attacker);
            boolean hasHardeningBonus = this.getHakiNature() == SourceHakiNature.HARDENING && hasHardeningActive;
            boolean hasImbuingBonus = this.getHakiNature() == SourceHakiNature.IMBUING && hasImbuingActive;
            boolean hasAdvancedBusoBonus = (this.getHakiNature() == SourceHakiNature.HARDENING || this.getHakiNature() == SourceHakiNature.IMBUING) && hasAdvancedBusoActive;
            boolean hasSpecialBonus = this.getHakiNature() == SourceHakiNature.SPECIAL && (hasHardeningActive || hasImbuingActive || hasAdvancedBusoActive);
            boolean bl3 = hasInfusion = this.getHakiNature() != SourceHakiNature.UNKNOWN && HakiHelper.hasInfusionActive(attacker);
            if (hasSpecialBonus) {
                if (hasHardeningActive || hasImbuingActive) {
                    damage = (float)((double)damage + HakiHelper.getBasicBusoshokuHakiDamageBoost(attacker, originalAmount));
                }
                if (hasAdvancedBusoActive) {
                    damage = (float)((double)damage + HakiHelper.getAdvancedBusoshokuHakiDamageBoost(attacker));
                }
            }
            if (hasHardeningBonus || hasImbuingBonus) {
                damage = (float)((double)damage + HakiHelper.getBasicBusoshokuHakiDamageBoost(attacker, originalAmount));
            }
            if (hasAdvancedBusoBonus) {
                damage = (float)((double)damage + HakiHelper.getAdvancedBusoshokuHakiDamageBoost(attacker));
            }
            if (hasInfusion) {
                damage = (float)((double)damage + HaoshokuHakiInfusionAbility.getDamageBoost(attacker, originalAmount));
            }
        }
        return damage;
    }
}

