/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.effects;

import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HungerOverTimeEffect
extends ModEffect {
    private final DamageSource source;
    private final float baseHunger;
    private final int freq;
    private Function<Integer, Float> hungerFunction;

    public HungerOverTimeEffect() {
        this(DamageSource.field_76366_f, 2.0f, 20);
    }

    public HungerOverTimeEffect(DamageSource source, float baseDamage, int freq) {
        super(EffectType.HARMFUL, WyHelper.hexToRGB("#000000").getRGB());
        this.source = source;
        this.baseHunger = baseDamage;
        this.freq = freq;
        this.hungerFunction = amp -> Float.valueOf(this.baseHunger * (float)amp.intValue());
    }

    public boolean shouldRender(EffectInstance effect) {
        return false;
    }

    public boolean shouldRenderHUD(EffectInstance effect) {
        return false;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % this.freq == 0;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        if (entity instanceof PlayerEntity) {
            float damage = Math.max(this.baseHunger, this.hungerFunction.apply(amplifier).floatValue());
            int foodLevel = (int)((float)((PlayerEntity)entity).func_71024_bL().func_75116_a() - damage);
            foodLevel = Math.max(foodLevel, 0);
            ((PlayerEntity)entity).func_71024_bL().func_75114_a(foodLevel);
        }
    }

    public float getBaseHunger() {
        return this.baseHunger;
    }

    public void setHungerFunction(Function<Integer, Float> func) {
        this.hungerFunction = func;
    }

    @Override
    public boolean isLingering() {
        return true;
    }
}

