/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.entities.ITrainer;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.RandomWalkingAroundHomeGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SelfHealEatGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenQuestChooseScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public abstract class TrainerEntity
extends OPEntity
implements ITrainer {
    private static final float SPAWNER_DESPAWN_DISTANCE = 40000.0f;
    public static final Ability.ICanUseEvent BELOW_90_CHECK = (entity, ability) -> {
        float per = entity.func_110143_aJ() / entity.func_110138_aP();
        if ((double)per > 0.9) {
            return AbilityUseResult.fail(null);
        }
        return AbilityUseResult.success();
    };

    public TrainerEntity(EntityType type, World world) {
        this(type, world, null);
    }

    public TrainerEntity(EntityType type, World world, ResourceLocation[] textures) {
        super(type, world, textures);
    }

    public void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, new RandomWalkingAroundHomeGoal<TrainerEntity>(this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new SelfHealEatGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setFaction(ModValues.CIVILIAN);
    }

    @Override
    public boolean func_213397_c(double distance) {
        if (this.isSpawnedViaSpawner() && distance < 40000.0) {
            return false;
        }
        return !this.func_145818_k_() || CommonConfig.INSTANCE.getDespawnWithNametag();
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !WyHelper.isInChallengeDimension(this.field_70170_p)) {
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.func_130011_c(null);
        }
        super.func_70071_h_();
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151057_cb) {
            return ActionResultType.FAIL;
        }
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SOpenQuestChooseScreenPacket(this.func_145782_y(), WyHelper.isInCombat((LivingEntity)player)), player);
            if (this instanceof IHakiTrainer) {
                WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), HakiDataCapability.get((LivingEntity)player)), player);
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }
}

