/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities.revenge;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.IRevengeCheck;

public class PhysicalDamageDealtRevengeCheck
implements IRevengeCheck {
    private float prevHealth;
    private float lostHealth;
    private float multiplier = 1.0f;

    public PhysicalDamageDealtRevengeCheck() {
    }

    public PhysicalDamageDealtRevengeCheck(float multipler) {
        this.multiplier = multipler;
    }

    @Override
    public boolean check(LivingEntity entity) {
        if (this.prevHealth == 0.0f) {
            this.prevHealth = entity.func_110143_aJ();
        }
        boolean isPhysical = false;
        DamageSource source = entity.func_189748_bU();
        if (source != null) {
            isPhysical |= source instanceof EntityDamageSource && source.field_76373_n.equals("player");
            isPhysical |= source instanceof AbilityDamageSource && ((AbilityDamageSource)source).isPhysical();
        }
        if (isPhysical && entity.func_110143_aJ() < this.prevHealth) {
            this.lostHealth = this.prevHealth - entity.func_110143_aJ();
            this.prevHealth = entity.func_110143_aJ();
            return true;
        }
        return false;
    }

    @Override
    public void resetMarkers() {
        this.prevHealth = 0.0f;
        this.lostHealth = 0.0f;
    }

    @Override
    public int revengeMeterGain() {
        return Math.round(this.lostHealth * this.multiplier);
    }

    public float getDamagePool() {
        return this.lostHealth;
    }
}

