/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.events.ability;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class ModifyDevilFruitEvent
extends Event {
    private final AkumaNoMiItem fruit;
    private final ImmutableList<AbilityCore<?>> originalAbilities;
    private List<AbilityCore<?>> abilities;

    public ModifyDevilFruitEvent(AkumaNoMiItem fruit, AbilityCore<?> ... abilities) {
        this.fruit = fruit;
        this.originalAbilities = ImmutableList.copyOf((Object[])abilities);
        this.abilities = Lists.newArrayList((Object[])abilities);
    }

    public void addAbilityCore(AbilityCore<?> core) {
        this.abilities.add(core);
    }

    public void removeAbilityCore(AbilityCore<?> core) {
        this.abilities.remove(core);
    }

    public void removeAbilityCore(Class<? extends Ability> clz) {
        this.abilities.removeIf(abl -> abl.createAbility().getClass().equals(clz));
    }

    public AbilityCore<?>[] getAbilities() {
        return this.abilities.toArray(new AbilityCore[0]);
    }

    public final ImmutableList<AbilityCore<?>> getOriginalAbilities() {
        return this.originalAbilities;
    }

    public final AkumaNoMiItem getFruitItem() {
        return this.fruit;
    }
}

