/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.DroppedDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.InventoryDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DevilFruitHelper {
    private static final double REINCARNATION_RANGE = 60.0;
    @Deprecated
    public static final HashMap<String, String> ZOAN_MODELS = new HashMap();

    public static boolean canDevilFruitRespawn() {
        return (Boolean)GeneralConfig.DEVIL_FRUIT_KEEP.get() == false;
    }

    public static boolean respawnDevilFruit(LivingEntity entity, IDevilFruit props) {
        boolean flag;
        boolean isYomi;
        if (!DevilFruitHelper.canDevilFruitRespawn()) {
            return false;
        }
        ChallengesWorldData challengeWorldData = ChallengesWorldData.get();
        InProgressChallenge challenge = challengeWorldData.getInProgressChallengeFor(entity);
        if (challenge != null) {
            return false;
        }
        if (!props.hasAnyDevilFruit()) {
            return false;
        }
        boolean bl = isYomi = props.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && !((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(entity);
        if (isYomi) {
            return false;
        }
        double chance = WyHelper.randomWithRange(1, 100);
        OFPWWorldData worldData = OFPWWorldData.get();
        List droppedItems = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 60.0, null, ItemEntity.class);
        droppedItems.removeIf(entry -> !entry.func_92059_d().func_77973_b().func_206844_a(ModTags.Items.FRUIT_REINCARNATION));
        if (!droppedItems.isEmpty() && chance <= CommonConfig.INSTANCE.getChanceForDroppedAppleReincarnation()) {
            AkumaNoMiItem fruit = (AkumaNoMiItem)props.getDevilFruitItem();
            if (CommonConfig.INSTANCE.getRandomizedFruits()) {
                fruit = fruit.getReverseShiftedFruit(entity.field_70170_p);
            }
            ((ItemEntity)droppedItems.get(0)).func_92058_a(new ItemStack((IItemProvider)fruit));
            worldData.updateOneFruit(fruit.getRegistryName(), null, OneFruitEntry.Status.DROPPED, "Reincarnated when " + entity.func_145748_c_().getString() + " died", true);
            DroppedDevilFruitEvent droppedEvent = new DroppedDevilFruitEvent(entity, fruit, "Reincarnated when " + entity.func_145748_c_().getString() + " died");
            MinecraftForge.EVENT_BUS.post((Event)droppedEvent);
            entity.field_70170_p.func_184133_a(null, ((ItemEntity)droppedItems.get(0)).func_233580_cy_(), (SoundEvent)ModSounds.FRUIT_REINCARNATION.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
            return true;
        }
        List players = WyHelper.getNearbyPlayers(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 60.0, null);
        players.removeIf(entry -> !DevilFruitHelper.hasFruitReincarnationInInventory((LivingEntity)entry));
        if (!players.isEmpty() && chance <= CommonConfig.INSTANCE.getChanceForInventoryAppleReincarnation() && (flag = DevilFruitHelper.setFruitInInv((IInventory)((PlayerEntity)players.get((int)0)).field_71071_by, (LivingEntity)players.get(0), entity, entity.field_70170_p, props.getDevilFruit().get()))) {
            entity.field_70170_p.func_184133_a(null, ((PlayerEntity)players.get(0)).func_233580_cy_(), (SoundEvent)ModSounds.FRUIT_REINCARNATION.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
            return true;
        }
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            boolean flag2;
            List villagers = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 60.0, null, VillagerEntity.class);
            villagers.removeIf(entry -> !DevilFruitHelper.hasFruitReincarnationInInventory((LivingEntity)entry));
            if (!villagers.isEmpty() && chance <= CommonConfig.INSTANCE.getChanceForInventoryAppleReincarnation() && (flag2 = DevilFruitHelper.setFruitInInv((IInventory)((VillagerEntity)villagers.get(0)).func_213715_ed(), (LivingEntity)villagers.get(0), entity, entity.field_70170_p, props.getDevilFruit().get()))) {
                entity.field_70170_p.func_184133_a(null, ((VillagerEntity)villagers.get(0)).func_233580_cy_(), (SoundEvent)ModSounds.FRUIT_REINCARNATION.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
                return true;
            }
            List<BlockPos> blockPosList = WyHelper.getNearbyBlocks((Entity)entity, 60);
            if (!blockPosList.isEmpty() && chance <= CommonConfig.INSTANCE.getChanceForChestAppleReincarnation()) {
                for (BlockPos blockPos : blockPosList) {
                    IInventory inv;
                    boolean flag3;
                    BlockState state = entity.field_70170_p.func_180495_p(blockPos);
                    if (!(state.func_177230_c() instanceof ChestBlock) || !(flag3 = DevilFruitHelper.setFruitInInv(inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)state.func_177230_c()), (BlockState)state, (World)entity.field_70170_p, (BlockPos)blockPos, (boolean)false), null, entity, entity.field_70170_p, props.getDevilFruit().get()))) continue;
                    entity.field_70170_p.func_184133_a(null, blockPos, (SoundEvent)ModSounds.FRUIT_REINCARNATION.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasFruitReincarnationInInventory(LivingEntity entity) {
        for (ItemStack stack : ItemsHelper.getAllInventoryItems(entity)) {
            if (!stack.func_77973_b().func_206844_a(ModTags.Items.FRUIT_REINCARNATION)) continue;
            return true;
        }
        return false;
    }

    private static boolean setFruitInInv(@Nullable IInventory inv, @Nullable LivingEntity invOwner, LivingEntity entity, World level, ResourceLocation df) {
        if (inv == null) {
            return false;
        }
        int stackIndex = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_70301_a(i).func_77973_b().func_206844_a(ModTags.Items.FRUIT_REINCARNATION)) continue;
            stackIndex = i;
            break;
        }
        if (stackIndex != -1) {
            AkumaNoMiItem fruit = (AkumaNoMiItem)DevilFruitHelper.getDevilFruitItem(df);
            if (CommonConfig.INSTANCE.getRandomizedFruits()) {
                fruit = fruit.getReverseShiftedFruit(level);
            }
            inv.func_70299_a(stackIndex, new ItemStack((IItemProvider)fruit));
            UUID invOwnerUUID = invOwner != null ? invOwner.func_110124_au() : null;
            OFPWWorldData.get().updateOneFruit(fruit.getRegistryName(), invOwnerUUID, OneFruitEntry.Status.INVENTORY, "Reincarnated in " + entity.func_145748_c_().getString() + "'s inventory", true);
            InventoryDevilFruitEvent postEvent = new InventoryDevilFruitEvent(invOwner, DevilFruitHelper.getDevilFruitItem(df), "Reincarnated in " + entity.func_145748_c_().getString() + "'s inventory");
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            return true;
        }
        return false;
    }

    @Nullable
    public static AkumaNoMiItem findAvailableOneFruit(World world, @Nullable Item devilFruitItem) {
        boolean isAvailable;
        if (devilFruitItem == null || !(devilFruitItem instanceof AkumaNoMiItem)) {
            return null;
        }
        AkumaNoMiItem fruit = (AkumaNoMiItem)devilFruitItem;
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return fruit;
        }
        OFPWWorldData worldProps = OFPWWorldData.get();
        int tier = fruit.getTier();
        ResourceLocation key = fruit.getRegistryName();
        boolean bl = isAvailable = !worldProps.isFruitInWorld(key);
        if (isAvailable) {
            return fruit;
        }
        List fruitsLeft = WyHelper.shuffle(ModValues.DEVIL_FRUITS).stream().filter(f -> f.getTier() == tier && !worldProps.isFruitInWorld(f.getRegistryName())).collect(Collectors.toList());
        if (fruitsLeft.size() > 0) {
            fruit = (AkumaNoMiItem)fruitsLeft.get(0);
            return fruit;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Item getDevilFruitItem(String key) {
        ResourceLocation res = new ResourceLocation(key);
        if (key.equals("yamidummy")) {
            res = ModAbilities.YAMI_YAMI_NO_MI.getRegistryName();
        }
        return (Item)ForgeRegistries.ITEMS.getValue(res);
    }

    @Nullable
    public static Item getDevilFruitItem(ResourceLocation key) {
        return (Item)ForgeRegistries.ITEMS.getValue(key);
    }

    @Deprecated
    @Nullable
    public static Item getLegacyDevilFruitItem(String key) {
        String model = "";
        String fullModel = "";
        for (Map.Entry<String, String> entry : ZOAN_MODELS.entrySet()) {
            if (!key.equals(entry.getKey())) continue;
            model = entry.getValue();
            fullModel = "_model_" + model;
            break;
        }
        if (key.equals("yamidummy")) {
            key = "yami_yami";
        }
        String finalName = (!Strings.isNullOrEmpty((String)model) ? key.replace("_" + model, "") : key) + "_no_mi" + fullModel;
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mineminenomi", finalName));
    }

    @Deprecated
    @Nullable
    public static ItemStack getDevilFruitItemStack(String key) {
        return new ItemStack((IItemProvider)DevilFruitHelper.getDevilFruitItem(key));
    }

    @Deprecated
    @Nullable
    public static ItemStack getDevilFruitItemStack(ResourceLocation key) {
        return new ItemStack((IItemProvider)DevilFruitHelper.getDevilFruitItem(key));
    }

    public static boolean hasDFLimitInInventory(PlayerEntity player) {
        boolean canYamiPickupFruit;
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            return false;
        }
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        int fruitsFound = ItemsHelper.getAllInventoryItems((LivingEntity)player).stream().filter(itemStack -> itemStack.func_77973_b() instanceof AkumaNoMiItem).collect(Collectors.toList()).size();
        boolean bl = canYamiPickupFruit = devilFruitProps.getDevilFruit().isPresent() && devilFruitProps.getDevilFruit().get().equals((Object)ModAbilities.YAMI_YAMI_NO_MI.getRegistryName()) && CommonConfig.INSTANCE.isYamiPowerEnabled() && fruitsFound == 0;
        if (DevilFruitCapability.get((LivingEntity)player).hasAnyDevilFruit() && CommonConfig.INSTANCE.getUnableToPickDFAsUser() && !canYamiPickupFruit) {
            return true;
        }
        return fruitsFound >= CommonConfig.INSTANCE.getInventoryLimitForFruits();
    }

    public static void vanillaFlightThreshold(LivingEntity entity, int height) {
        if (entity.func_226278_cu_() > (double)height) {
            AbilityHelper.setDeltaMovement((Entity)entity, entity.func_213322_ci().func_72441_c(0.0, 0.25 * (double)((float)height / 5.0f), 0.0).func_216372_d(1.0, -0.15, 1.0));
        }
    }

    public static boolean flyingAtMaxHeight(LivingEntity player, double maxDifference) {
        return maxDifference > DevilFruitHelper.getDifferenceToFloor((Entity)player);
    }

    public static double getDifferenceToFloor(Entity entity) {
        return entity.func_213303_ch().func_178788_d((Vector3d)DevilFruitHelper.getFloorLevel((Entity)entity)).field_72448_b;
    }

    public static Vector3d getFloorLevel(Entity entity) {
        Vector3d startVec = entity.func_213303_ch();
        Vector3d endVec = startVec.func_72441_c(0.0, -256.0, 0.0);
        BlockRayTraceResult blockResult = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, entity));
        return blockResult.func_216347_e();
    }

    static {
        ZOAN_MODELS.put("ushi_ushi_bison", "bison");
        ZOAN_MODELS.put("tori_tori_phoenix", "phoenix");
        ZOAN_MODELS.put("ushi_ushi_giraffe", "giraffe");
        ZOAN_MODELS.put("zou_zou_mammoth", "mammoth");
        ZOAN_MODELS.put("hito_hito_daibutsu", "daibutsu");
        ZOAN_MODELS.put("neko_neko_leopard", "leopard");
        ZOAN_MODELS.put("ryu_ryu_pteranodon", "pteranodon");
        ZOAN_MODELS.put("ryu_ryu_brachiosaurus", "brachiosaurus");
        ZOAN_MODELS.put("sara_sara_axolotl", "axolotl");
        ZOAN_MODELS.put("ryu_ryu_allosaurus", "allosaurus");
    }
}

