/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FactionHelper {
    private static final Color CIVILIAN_COLOR = WyHelper.hexToRGB("#55FF55");
    private static final Color MARINE_COLOR = WyHelper.hexToRGB("#55DDFF");
    private static final Color PIRATE_COLOR;
    private static final Color REVO_COLOR;
    private static final Color BOUNTY_HUNTER_COLOR;
    private static final Color BANDIT_COLOR;

    @Nullable
    public static ResourceLocation getFactionIcon(IEntityStats props) {
        ResourceLocation icon = null;
        if (props.isPirate()) {
            icon = ModResources.PIRATE_ICON;
        } else if (props.isMarine()) {
            icon = ModResources.MARINE_ICON_GREYSCALE;
        } else if (props.isBountyHunter()) {
            icon = ModResources.BOUNTY_HUNTER_ICON_GREYSCALE;
        } else if (props.isRevolutionary()) {
            icon = ModResources.REVOLUTIONARY_ARMY_ICON_GREYSCALE;
        }
        return icon;
    }

    public static Color getFactionColor(IEntityStats props) {
        if (props.isPirate()) {
            return PIRATE_COLOR;
        }
        if (props.isRevolutionary()) {
            return REVO_COLOR;
        }
        if (props.isMarine()) {
            return MARINE_COLOR;
        }
        if (props.isBountyHunter()) {
            return BOUNTY_HUNTER_COLOR;
        }
        if (props.isBandit()) {
            return BANDIT_COLOR;
        }
        return CIVILIAN_COLOR;
    }

    public static int getFactionRGBColor(IEntityStats props) {
        return FactionHelper.getFactionColor(props).getRGB();
    }

    public static void sendMessageToCrew(World world, Crew crew, ITextComponent message) {
        for (Crew.Member member : crew.getMembers()) {
            UUID uuid = member.getUUID();
            PlayerEntity memberPlayer = world.func_217371_b(uuid);
            if (memberPlayer == null || !memberPlayer.func_70089_S()) continue;
            memberPlayer.func_145747_a(message, Util.field_240973_b_);
        }
    }

    public static void validateFaction(PlayerEntity player) {
        Crew crew;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get();
        if (!EntityStatsCapability.get((LivingEntity)player).isPirate() && (crew = worldData.getCrewWithMember(player.func_110124_au())) != null) {
            worldData.removeCrewMember(player.field_70170_p, crew, player.func_110124_au());
        }
    }

    static {
        REVO_COLOR = PIRATE_COLOR = WyHelper.hexToRGB("#FF2200");
        BOUNTY_HUNTER_COLOR = WyHelper.hexToRGB("#BBFF88");
        BANDIT_COLOR = WyHelper.hexToRGB("#925959");
    }

    public static enum RevolutionaryRank {
        MEMBER(ModI18n.REVOLUTIONARY_TITLE_MEMBER, 0),
        OFFICER(ModI18n.REVOLUTIONARY_TITLE_OFFICER, 30),
        COMMANDER(ModI18n.REVOLUTIONARY_TITLE_COMMANDER, 50),
        CHIEF_OF_STAFF(ModI18n.REVOLUTIONARY_TITLE_CHIEF_OF_STAFF, 80),
        SUPREME_COMMANDER(ModI18n.REVOLUTIONARY_TITLE_SUPREME_COMMANDER, 100);

        private String unlocalizedName;
        private int loyaltyRequired;

        private RevolutionaryRank(String unlocalizedName, int loyaltyRequired) {
            this.unlocalizedName = unlocalizedName;
            this.loyaltyRequired = loyaltyRequired;
        }

        public String getLocalizedName() {
            return new TranslationTextComponent(this.unlocalizedName).getString();
        }

        public int getRequiredLoyalty() {
            return this.loyaltyRequired;
        }
    }

    public static enum MarineRank {
        CHORE_BOY(ModI18n.MARINE_TITLE_CHORE_BOY, 0),
        SEAMAN(ModI18n.MARINE_TITLE_SEAMAN, 5),
        PETTY_OFFICER(ModI18n.MARINE_TITLE_PETTY_OFFICER, 10),
        LIEUTENANT(ModI18n.MARINE_TITLE_LIEUTENANT, 15),
        COMMANDER(ModI18n.MARINE_TITLE_COMMANDER, 20),
        CAPTAIN(ModI18n.MARINE_TITLE_CAPTAIN, 25),
        COMMODORE(ModI18n.MARINE_TITLE_COMMODORE, 40),
        VICE_ADMIRAL(ModI18n.MARINE_TITLE_VICE_ADMIRAL, 50),
        ADMIRAL(ModI18n.MARINE_TITLE_ADMIRAL, 70),
        FLEET_ADMIRAL(ModI18n.MARINE_TITLE_FLEET_ADMIRAL, 100);

        private String unlocalizedName;
        private int loyaltyRequired;

        private MarineRank(String unlocalizedName, int loyaltyRequired) {
            this.unlocalizedName = unlocalizedName;
            this.loyaltyRequired = loyaltyRequired;
        }

        public String getLocalizedName() {
            return new TranslationTextComponent(this.unlocalizedName).getString();
        }

        public int getRequiredLoyalty() {
            return this.loyaltyRequired;
        }
    }
}

