/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.abilities.ExplosionImmunityAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaLogiaAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.entities.IThreatLevel;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.ITamableEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.awa.GoldenHourWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.awa.RelaxHourWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.awa.SoapDefenseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bane.SpringDeathKnockWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bane.SpringSnipeWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.BreezeBreathBombWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.ExplosivePunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.KickBombWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.NoseFancyCannonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.GenkotsuMeteorWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.CandleChampionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.CandleLockWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.CandleWallWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruArtsKenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruArtsMoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruBallWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruNoYakataWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.goe.DragonsRoarWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.goe.TodorokiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiEmissionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kachi.EvaporateWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kachi.HotBoilingSpecialWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kachi.VulcanizationWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kilo.KiloPress10000WrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kilo.KiloPress1WrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kilo.KiloPunch5000WrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.TekkaiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sube.SubeSubeSpurWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suke.ShishaNoTeWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suke.SkattingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.BarjanWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.DesertEncierroWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.DesertGrandeEspadaWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.DesertSpadaWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.GroundSeccoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.SablesGuardWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.SablesPesadoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SparClawWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SparklingDaisyWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SpiderWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SpiralHollowWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.HiryuKaenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.OTatsumakiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.SanbyakurokujuPoundHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.ShiShishiSonsonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.YakkodoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class MobsHelper {
    public static final Color MARINE_BLUE_COLOR = WyHelper.hexToRGB("#0084BC");
    public static final ArrayList<Supplier<? extends Item>> PIRATE_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.CUTLASS, ModWeapons.KATANA, ModWeapons.AXE, () -> Items.field_151040_l, () -> Items.field_151052_q, () -> Items.field_151049_t, () -> Items.field_151036_c});
    public static final ArrayList<Supplier<? extends Item>> MARINE_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.BROADSWORD, ModWeapons.KATANA, ModWeapons.SPEAR, () -> Items.field_151040_l, () -> Items.field_151052_q});
    public static final ArrayList<Supplier<? extends Item>> MARINE_CAPTAIN_SWORDS = MobsHelper.createMarineCaptainWeaponsList();
    public static final ArrayList<Supplier<? extends Item>> BANDIT_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.DAGGER, ModWeapons.AXE, ModWeapons.KATANA, () -> Items.field_151049_t, () -> Items.field_151036_c});
    public static final ArrayList<Supplier<? extends Item>> BRUTE_SWORDS = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.MACE, ModWeapons.DALTONS_SPADE, ModWeapons.CLEAVER, () -> Items.field_151036_c});
    public static final ArrayList<Supplier<? extends Item>> GORILLA_AXES = Lists.newArrayList((Object[])new Supplier[]{() -> Items.field_151036_c, () -> Items.field_151006_E, () -> Items.field_151049_t, () -> Items.field_151056_x});
    public static final ResourceLocation[] PIRATE_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("pirate6"), MobsHelper.entityTexture("pirate7"), MobsHelper.entityTexture("pirate8")};
    public static final ResourceLocation[] PIRATE_FISHMEN_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("fishman_pirate1"), MobsHelper.entityTexture("fishman_pirate2"), MobsHelper.entityTexture("fishman_pirate3")};
    public static final ResourceLocation[] PIRATE_CAPTAINS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("pirate_captain1"), MobsHelper.entityTexture("pirate_captain2"), MobsHelper.entityTexture("pirate_captain3"), MobsHelper.entityTexture("pirate_captain4"), MobsHelper.entityTexture("pirate_captain5"), MobsHelper.entityTexture("pirate_captain6"), MobsHelper.entityTexture("pirate_captain7"), MobsHelper.entityTexture("pirate_captain8")};
    public static final ResourceLocation[] PIRATE_TRADERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("pirate_trader1"), MobsHelper.entityTexture("pirate_trader2")};
    public static final ResourceLocation[] MARINE_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine1"), MobsHelper.entityTexture("marine2"), MobsHelper.entityTexture("marine3"), MobsHelper.entityTexture("marine4"), MobsHelper.entityTexture("marine5")};
    public static final ResourceLocation[] MARINE_CAPTAINS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine_captain1"), MobsHelper.entityTexture("marine_captain2"), MobsHelper.entityTexture("marine_captain3"), MobsHelper.entityTexture("marine_captain4"), MobsHelper.entityTexture("marine_captain5")};
    public static final ResourceLocation[] MARINE_TRADERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine_trader1"), MobsHelper.entityTexture("marine_trader2")};
    public static final ResourceLocation[] CELESTIAL_DRAGONS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("celestial_dragon1"), MobsHelper.entityTexture("celestial_dragon2")};
    public static final ResourceLocation[] MARINE_VICE_ADMIRAL_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("marine_vice_admiral1"), MobsHelper.entityTexture("marine_vice_admiral2"), MobsHelper.entityTexture("marine_vice_admiral3")};
    public static final ResourceLocation[] BANDIT_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("bandit1"), MobsHelper.entityTexture("bandit2"), MobsHelper.entityTexture("bandit3")};
    public static final ResourceLocation[] SKYPEAN_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("skypiean_civilian1"), MobsHelper.entityTexture("skypiean_civilian2"), MobsHelper.entityTexture("skypiean_civilian3")};
    public static final ResourceLocation[] SKYPEAN_TRADERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("skypiean_trader1"), MobsHelper.entityTexture("skypiean_trader2")};
    public static final ResourceLocation[] BARKEEPER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("barkeeper_1")};
    public static final ResourceLocation[] SWORDSMAN_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dojosensei1"), MobsHelper.entityTexture("dojosensei2"), MobsHelper.entityTexture("dojosensei3")};
    public static final ResourceLocation[] SNIPER_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("bow_master1"), MobsHelper.entityTexture("bow_master2")};
    public static final ResourceLocation[] DOCTOR_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("doctor1"), MobsHelper.entityTexture("doctor2")};
    public static final ResourceLocation[] BRAWLER_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("brawler_trainer1"), MobsHelper.entityTexture("brawler_trainer2")};
    public static final ResourceLocation[] BLACK_LEG_TRAINERS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("black_leg_trainer1"), MobsHelper.entityTexture("black_leg_trainer2")};
    public static final ResourceLocation[] WEATHER_TRAINER_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("weather_wizard1")};
    public static final ResourceLocation[] DEN_DEN_MUSHI_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("den_den_mushi1"), MobsHelper.entityTexture("den_den_mushi2"), MobsHelper.entityTexture("den_den_mushi3")};
    public static final ResourceLocation[] YAGARA_BULL_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("yagara_bull1"), MobsHelper.entityTexture("yagara_bull2"), MobsHelper.entityTexture("yagara_bull3")};
    public static final ResourceLocation[] NIGHTMARE_SOLDIER_TEXTURES = WyHelper.concatAllArrays(PIRATE_TEXTURES, PIRATE_FISHMEN_TEXTURES, MARINE_TEXTURES, BANDIT_TEXTURES);
    public static final ResourceLocation[] DUGONG_HEAD_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/head_0"), MobsHelper.entityTexture("dugong_scars/head_1"), MobsHelper.entityTexture("dugong_scars/head_2"), MobsHelper.entityTexture("dugong_scars/head_3"), MobsHelper.entityTexture("dugong_scars/head_4")};
    public static final ResourceLocation[] DUGONG_CHEST_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/chest_0"), MobsHelper.entityTexture("dugong_scars/chest_1"), MobsHelper.entityTexture("dugong_scars/chest_2")};
    public static final ResourceLocation[] DUGONG_ARMS_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/arms_0"), MobsHelper.entityTexture("dugong_scars/arms_1")};
    public static final ResourceLocation[] DUGONG_TAIL_SCARS_TEXTURES = new ResourceLocation[]{MobsHelper.entityTexture("dugong_scars/tail_0"), MobsHelper.entityTexture("dugong_scars/tail_1"), MobsHelper.entityTexture("dugong_scars/tail_2")};
    private static final Map<ResourceLocation, List<Function<MobEntity, AbilityWrapperGoal>>> FRUIT_ABILITIES = MobsHelper.createFruitAbilitiesMap();
    public static final Comparator<LivingEntity> ENTITY_THREAT = new Comparator<LivingEntity>(){

        @Override
        public int compare(LivingEntity e1, LivingEntity e2) {
            int e1Threat = (int)EntityStatsCapability.get(e1).getDoriki();
            int e2Threat = (int)EntityStatsCapability.get(e2).getDoriki();
            return e1Threat - e2Threat;
        }
    };

    private static ArrayList<Supplier<? extends Item>> createMarineCaptainWeaponsList() {
        ArrayList list = Lists.newArrayList((Object[])new Supplier[]{ModWeapons.JITTE, ModWeapons.BISENTO, () -> Items.field_151048_u});
        list.addAll(MARINE_SWORDS);
        return list;
    }

    private static Map<ResourceLocation, List<Function<MobEntity, AbilityWrapperGoal>>> createFruitAbilitiesMap() {
        HashMap<ResourceLocation, List<Function<MobEntity, AbilityWrapperGoal>>> map = new HashMap<ResourceLocation, List<Function<MobEntity, AbilityWrapperGoal>>>();
        map.put(ModAbilities.SUKE_SUKE_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{SkattingWrapperGoal::new, ShishaNoTeWrapperGoal::new}));
        map.put(ModAbilities.KILO_KILO_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{KiloPress1WrapperGoal::new, KiloPress10000WrapperGoal::new, KiloPunch5000WrapperGoal::new}));
        map.put(ModAbilities.DORU_DORU_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{CandleChampionWrapperGoal::new, CandleLockWrapperGoal::new, CandleWallWrapperGoal::new, DoruDoruArtsKenWrapperGoal::new, DoruDoruArtsMoriWrapperGoal::new, DoruDoruBallWrapperGoal::new, DoruDoruNoYakataWrapperGoal::new}));
        map.put(ModAbilities.BOMU_BOMU_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{BreezeBreathBombWrapperGoal::new, ExplosivePunchWrapperGoal::new, KickBombWrapperGoal::new, NoseFancyCannonWrapperGoal::new, mob -> new AlwaysActiveAbilityWrapperGoal<ExplosionImmunityAbility>((MobEntity)mob, ExplosionImmunityAbility.INSTANCE)}));
        map.put(ModAbilities.SUPA_SUPA_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{SparClawWrapperGoal::new, SparklingDaisyWrapperGoal::new, SpiderWrapperGoal::new, SpiralHollowWrapperGoal::new}));
        map.put(ModAbilities.SUNA_SUNA_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{BarjanWrapperGoal::new, DesertEncierroWrapperGoal::new, DesertGrandeEspadaWrapperGoal::new, DesertSpadaWrapperGoal::new, GroundSeccoWrapperGoal::new, SablesGuardWrapperGoal::new, SablesPesadoWrapperGoal::new, mob -> new AlwaysActiveAbilityWrapperGoal<SunaLogiaAbility>((MobEntity)mob, SunaLogiaAbility.INSTANCE)}));
        map.put(ModAbilities.SUBE_SUBE_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{SubeSubeSpurWrapperGoal::new}));
        map.put(ModAbilities.GOE_GOE_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{TodorokiWrapperGoal::new, DragonsRoarWrapperGoal::new}));
        map.put(ModAbilities.KACHI_KACHI_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{VulcanizationWrapperGoal::new, HotBoilingSpecialWrapperGoal::new, EvaporateWrapperGoal::new}));
        map.put(ModAbilities.AWA_AWA_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{GoldenHourWrapperGoal::new, RelaxHourWrapperGoal::new, SoapDefenseWrapperGoal::new}));
        map.put(ModAbilities.BANE_BANE_NO_MI.getRegistryName(), Lists.newArrayList((Object[])new Function[]{SpringDeathKnockWrapperGoal::new, SpringSnipeWrapperGoal::new}));
        return map;
    }

    public static float getThreatLevel(LivingEntity entity) {
        float abilities;
        if (entity instanceof IThreatLevel) {
            return ((IThreatLevel)entity).getThreatLevel();
        }
        double doriki = EntityStatsCapability.get(entity).getDoriki() / (double)CommonConfig.INSTANCE.getDorikiLimit();
        doriki = MathHelper.func_151237_a((double)doriki, (double)0.0, (double)1.0);
        double haki = HakiDataCapability.get(entity).getTotalHakiExp() / (float)(CommonConfig.INSTANCE.getHakiExpLimit() * 2);
        haki = MathHelper.func_151237_a((double)haki, (double)0.0, (double)1.0);
        float f = abilities = AbilityDataCapability.get(entity).getUnlockedAbilities().size() >= 30 ? 1.0f : 0.0f;
        if (entity instanceof PlayerEntity) {
            abilities = 0.0f;
        }
        float threatLevel = (float)((doriki *= (double)0.4f) + (haki *= 0.5) + (double)(abilities *= 0.1f));
        threatLevel = MathHelper.func_76131_a((float)threatLevel, (float)0.0f, (float)1.0f);
        return threatLevel;
    }

    public static Predicate<Entity> shouldTarget(LivingEntity entity) {
        return targetEntity -> {
            if (!(targetEntity instanceof LivingEntity)) {
                return false;
            }
            if (WyHelper.isInChallengeDimension(entity.field_70170_p)) {
                return true;
            }
            LivingEntity target = (LivingEntity)targetEntity;
            double entityThreatLevel = MobsHelper.getThreatLevel(entity);
            double targetThreatLevel = MobsHelper.getThreatLevel(target);
            if (entity.field_70170_p.func_175659_aa().func_151525_a() <= 2) {
                float mod = 0.0f;
                switch (entity.field_70170_p.func_175659_aa()) {
                    case EASY: {
                        mod = 0.6f;
                        break;
                    }
                    case NORMAL: {
                        mod = 0.3f;
                        break;
                    }
                }
                if (entityThreatLevel * (double)mod > targetThreatLevel) {
                    return false;
                }
            }
            return entityThreatLevel >= (targetThreatLevel *= 0.25);
        };
    }

    @Nullable
    public static LivingEntity getTamer(LivingEntity entity) {
        if (!ModEntityPredicates.canBeTamed().test((Entity)entity)) {
            return null;
        }
        if (entity instanceof TameableEntity) {
            return ((TameableEntity)entity).func_70902_q();
        }
        if (entity instanceof AbstractHorseEntity) {
            UUID ownerUuid = ((AbstractHorseEntity)entity).func_184780_dh();
            if (ownerUuid == null) {
                return null;
            }
            return entity.field_70170_p.func_217371_b(ownerUuid);
        }
        if (entity instanceof ITamableEntity) {
            ITamableEntity tamableEntity = (ITamableEntity)entity;
            return tamableEntity.getOwnerIfAlive();
        }
        if (entity instanceof ICommandReceiver) {
            return ((ICommandReceiver)entity).getLastCommandSender();
        }
        return null;
    }

    public static <T extends IAbility> T unlockAndEquipAbility(LivingEntity entity, AbilityCore<T> core) {
        IAbilityData props = AbilityDataCapability.get(entity);
        T ability = MobsHelper.unlockAbility(entity, core);
        int availableSlot = props.getEquippedAbilities().size();
        props.setEquippedAbility(availableSlot, (IAbility)ability);
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllAround(new SEquipAbilityPacket(entity.func_145782_y(), availableSlot, core), (Entity)entity);
        }
        return ability;
    }

    public static <T extends IAbility> T unlockAbility(LivingEntity entity, AbilityCore<T> core) {
        IAbilityData props = AbilityDataCapability.get(entity);
        props.addUnlockedAbility(core, AbilityUnlock.COMMAND);
        T ability = core.createAbility();
        return ability;
    }

    public static ResourceLocation entityTexture(String texture) {
        return MobsHelper.entityTexture("mineminenomi", texture);
    }

    public static ResourceLocation entityTexture(String modId, String texture) {
        return new ResourceLocation(modId, "textures/models/" + texture + ".png");
    }

    public static void addBasicNPCGoals(CreatureEntity entity) {
        Predicate<Entity> targetMobCheck;
        ((GroundPathNavigator)entity.func_70661_as()).func_179688_b(true);
        boolean isBoss = entity instanceof OPBossEntity;
        if (!isBoss) {
            entity.func_70661_as().func_212239_d(true);
            entity.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)entity));
            entity.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal(entity, 0.8));
        }
        entity.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)entity, true));
        entity.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)entity, LivingEntity.class, 8.0f));
        entity.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)entity));
        Predicate<Entity> hurtByCheck = ModEntityPredicates.getEnemyFactions((LivingEntity)entity).and(ModEntityPredicates.IS_ENTITY_HARMLESS.negate());
        Predicate<Entity> targetPlayerCheck = targetMobCheck = hurtByCheck.and(ModEntityPredicates.IS_INVISIBLE.negate()).and(MobsHelper.shouldTarget((LivingEntity)entity));
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        FactionHurtByTargetGoal hurtByTargetGoal = new FactionHurtByTargetGoal(entity, hurtByCheck, new Class[0]);
        if (props.isMarine() || props.isBountyHunter()) {
            targetPlayerCheck = targetPlayerCheck.and(ModEntityPredicates.TARGET_HAS_ISSUED_BOUNTY);
            hurtByTargetGoal.func_220794_a(new Class[0]);
        }
        entity.field_70715_bh.func_75776_a(1, (Goal)hurtByTargetGoal);
        entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, MobEntity.class, 10, true, true, targetMobCheck));
        entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, true, targetPlayerCheck));
    }

    @Deprecated
    public static Set<Goal> getBrawlerAbilities(MobEntity entity, int maxGoals) {
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new HakaiHoWrapperGoal(entity), 3.0f);
        goals.addEntry(() -> new SuplexWrapperGoal(entity), 3.0f);
        goals.addEntry(() -> new GenkotsuMeteorWrapperGoal(entity), 2.0f);
        goals.addEntry(() -> new JishinHoWrapperGoal(entity), 2.0f);
        goals.addEntry(() -> new SpinningBrawlWrapperGoal(entity), 1.0f);
        return MobsHelper.getRandomizedGoals(entity, maxGoals, goals);
    }

    @Deprecated
    public static void addBrawlerAbilities(MobEntity entity, int maxGoals) {
        MobsHelper.applyRandomizedGoals(entity, maxGoals, MobsHelper.getBrawlerAbilities(entity, maxGoals));
    }

    @Deprecated
    public static Set<Goal> getSwordsmanAbilities(MobEntity entity, int maxGoals) {
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new HiryuKaenWrapperGoal(entity), 4.0f);
        goals.addEntry(() -> new ShiShishiSonsonWrapperGoal(entity), 4.0f);
        goals.addEntry(() -> new YakkodoriWrapperGoal(entity), 3.0f);
        goals.addEntry(() -> new OTatsumakiWrapperGoal(entity), 2.0f);
        goals.addEntry(() -> new SanbyakurokujuPoundHoWrapperGoal(entity), 2.0f);
        return MobsHelper.getRandomizedGoals(entity, maxGoals, goals);
    }

    @Deprecated
    public static void addSwordsmanAbilities(MobEntity entity, int maxGoals) {
        MobsHelper.applyRandomizedGoals(entity, maxGoals, MobsHelper.getSwordsmanAbilities(entity, maxGoals));
    }

    @Deprecated
    public static Set<Goal> getRokushikiAbilities(MobEntity entity, int maxGoals) {
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new SoruWrapperGoal(entity), 10.0f);
        goals.addEntry(() -> new ShiganWrapperGoal(entity), 7.0f);
        goals.addEntry(() -> new TekkaiWrapperGoal(entity), 7.0f);
        goals.addEntry(() -> new RankyakuWrapperGoal(entity), 1.0f);
        return MobsHelper.getRandomizedGoals(entity, maxGoals, goals);
    }

    @Deprecated
    public static void addRokushikiAbilities(MobEntity entity, int maxGoals) {
        MobsHelper.applyRandomizedGoals(entity, maxGoals, MobsHelper.getRokushikiAbilities(entity, maxGoals));
    }

    public static void addBusoshokuHaki(MobEntity entity, int chance) {
        if ((double)chance > WyHelper.randomWithRange(0, 100)) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
            if (props.isSniper() || props.isSwordsman()) {
                hakiProps.setBusoshokuHakiExp(30 + entity.func_70681_au().nextInt(20));
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiImbuingWrapperGoal(entity));
                if ((double)(chance / 3) > WyHelper.randomWithRange(0, 100)) {
                    hakiProps.setBusoshokuHakiExp(50 + entity.func_70681_au().nextInt(20));
                    entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal(entity));
                }
            } else if ((double)(chance / 3) > WyHelper.randomWithRange(0, 100)) {
                hakiProps.setBusoshokuHakiExp(50 + entity.func_70681_au().nextInt(20));
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal(entity));
            } else {
                hakiProps.setBusoshokuHakiExp(30 + entity.func_70681_au().nextInt(20));
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiHardeningWrapperGoal(entity));
            }
        }
    }

    public static void addAdvancedBusoshokuHaki(MobEntity entity, int chance) {
        if ((double)chance > WyHelper.randomWithRange(0, 100)) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
            if (entity.func_70681_au().nextInt(10) < 6) {
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiEmissionWrapperGoal(entity));
            } else {
                entity.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal(entity));
            }
        }
    }

    public static Set<Goal> getRandomizedGoals(MobEntity entity, int maxGoals, WeightedList<Supplier<Goal>> list) {
        int rolls = 5;
        HashSet<Goal> goals = new HashSet<Goal>();
        if (list.size() <= 0) {
            return goals;
        }
        while (goals.size() < maxGoals && rolls > 0) {
            Goal goal = list.pick(entity.func_70681_au()).get();
            if (goal == null) {
                --rolls;
                continue;
            }
            boolean alreadyInList = goals.stream().map(g -> g.toString()).anyMatch(s -> goal.toString().equalsIgnoreCase((String)s));
            if (!alreadyInList) {
                goals.add(goal);
                continue;
            }
            --rolls;
        }
        return goals;
    }

    private static void applyRandomizedGoals(MobEntity entity, int maxGoals, Set<Goal> goals) {
        goals.forEach(goal -> entity.field_70714_bg.func_75776_a(4, goal));
    }

    public static Optional<List<AbilityWrapperGoal>> getRandomDevilFruitAbilities(MobEntity entity) {
        ResourceLocation fruit = (ResourceLocation)FRUIT_ABILITIES.keySet().toArray()[entity.func_70681_au().nextInt(FRUIT_ABILITIES.size())];
        if (fruit == null) {
            return Optional.empty();
        }
        return MobsHelper.getDevilFruitAbilities(entity, fruit);
    }

    public static Optional<List<AbilityWrapperGoal>> getDevilFruitAbilities(MobEntity entity, ResourceLocation fruit) {
        if (!FRUIT_ABILITIES.containsKey(fruit)) {
            return Optional.empty();
        }
        List<Function<MobEntity, AbilityWrapperGoal>> abilities = FRUIT_ABILITIES.get(fruit);
        if (abilities == null || abilities.isEmpty()) {
            return Optional.empty();
        }
        IDevilFruit fruitData = DevilFruitCapability.get((LivingEntity)entity);
        if (fruitData != null) {
            fruitData.setDevilFruit(fruit);
        }
        return Optional.ofNullable(abilities.stream().map(func -> (AbilityWrapperGoal)((Object)((Object)func.apply(entity)))).collect(Collectors.toList()));
    }
}

