/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;

public class TargetHelper {
    public static boolean isEntityInView(LivingEntity entity, Entity target, float fov) {
        float yaw;
        double dx = target.func_226277_ct_() - entity.func_226277_ct_();
        double dz = target.func_226281_cx_() - entity.func_226281_cx_();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        for (yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - entity.field_70177_z - 90.0f; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }

    public static <T extends LivingEntity> List<T> getEntitiesInArea(LivingEntity entity, double size, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        return TargetHelper.getEntitiesInArea(entity, size, size, size, targetPredicate, clazzez);
    }

    public static <T extends LivingEntity> List<T> getEntitiesInArea(LivingEntity entity, BlockPos centerPos, double size, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        return TargetHelper.getEntitiesInArea(entity, centerPos, size, size, size, targetPredicate, clazzez);
    }

    public static <T extends LivingEntity> List<T> getEntitiesInArea(LivingEntity entity, double sizeX, double sizeY, double sizeZ, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        return TargetHelper.getEntitiesInArea(entity, entity.func_233580_cy_(), sizeX, sizeY, sizeZ, targetPredicate, clazzez);
    }

    public static <T extends LivingEntity> List<T> getEntitiesInArea(LivingEntity entity, BlockPos centerPos, double sizeX, double sizeY, double sizeZ, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        if (clazzez.length <= 0) {
            clazzez = new Class[]{LivingEntity.class};
        }
        if (targetPredicate == null) {
            targetPredicate = TargetsPredicate.DEFAULT_AREA_CHECK;
        }
        ArrayList targets = new ArrayList();
        AxisAlignedBB area = new AxisAlignedBB(centerPos).func_72314_b(sizeX, sizeY, sizeZ);
        TargetsPredicate finalPredicate = targetPredicate;
        for (Class<? extends T> clz : clazzez) {
            entity.field_70170_p.func_217357_a(clz, area).stream().filter(target -> !targets.contains(target) && finalPredicate.test(entity, (LivingEntity)target)).forEach(targets::add);
        }
        return targets;
    }

    public static <T extends LivingEntity> List<T> getEntitiesInLine(LivingEntity entity, float distance, float size, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        return TargetHelper.getEntitiesInLine(entity, distance, size, size, size, targetPredicate, clazzez);
    }

    public static <T extends LivingEntity> List<T> getEntitiesInLine(LivingEntity entity, BlockPos centerPos, float distance, float size, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        return TargetHelper.getEntitiesInLine(entity, centerPos, distance, size, size, size, targetPredicate, clazzez);
    }

    public static <T extends LivingEntity> List<T> getEntitiesInLine(LivingEntity entity, float distance, float sizeX, float sizeY, float sizeZ, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        return TargetHelper.getEntitiesInLine(entity, entity.func_233580_cy_(), distance, sizeX, sizeY, sizeZ, targetPredicate, clazzez);
    }

    public static <T extends LivingEntity> List<T> getEntitiesInLine(LivingEntity entity, BlockPos centerPos, float distance, float sizeX, float sizeY, float sizeZ, @Nullable TargetsPredicate targetPredicate, Class<? extends T> ... clazzez) {
        if (clazzez.length <= 0) {
            clazzez = new Class[]{LivingEntity.class};
        }
        if (targetPredicate == null) {
            targetPredicate = TargetsPredicate.DEFAULT_LINE_CHECK;
        }
        ArrayList<Entity> targets = new ArrayList<Entity>();
        Vector3d lookVec = entity.func_70040_Z().func_72432_b();
        Vector3d pos = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        double distanceTraveled = 0.0;
        while (distanceTraveled < (double)distance) {
            distanceTraveled += lookVec.func_72433_c();
            pos = pos.func_178787_e(lookVec.func_186678_a(lookVec.func_72433_c()));
            double xOffset = (double)sizeX / 2.0;
            double yOffset = (double)sizeY / 2.0;
            double zOffset = (double)sizeZ / 2.0;
            AxisAlignedBB aabb = new AxisAlignedBB(pos.field_72450_a - xOffset, pos.field_72448_b - yOffset, pos.field_72449_c - zOffset, pos.field_72450_a + xOffset, pos.field_72448_b + yOffset, pos.field_72449_c + zOffset);
            TargetsPredicate finalPredicate = targetPredicate;
            for (Class<? extends T> clz : clazzez) {
                List entities = entity.field_70170_p.func_217357_a(clz, aabb);
                entities.stream().filter(target -> !targets.contains(target) && finalPredicate.test(entity, (LivingEntity)target)).forEach(targets::add);
            }
        }
        targets.sort(TargetHelper.closestComparator(entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0)));
        return targets;
    }

    public static Comparator<Entity> closestComparator(final Vector3d pos) {
        return new Comparator<Entity>(){

            @Override
            public int compare(Entity e1, Entity e2) {
                return (int)(e1.func_195048_a(pos) - e2.func_195048_a(pos));
            }
        };
    }
}

